/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.util;

import de.deepamehta.DeepaMehtaConstants;
import de.deepamehta.DeepaMehtaException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeepaMehtaUtils
implements DeepaMehtaConstants {
    public static String readFile(File file) throws IOException {
        int len = (int)file.length();
        char[] buffer = new char[len];
        FileReader in = new FileReader(file);
        in.read(buffer);
        in.close();
        return new String(buffer);
    }

    public static Vector readStrings(DataInputStream in) throws IOException {
        Vector<String> strings = new Vector<String>();
        int stringCount = in.readInt();
        int i = 0;
        while (i < stringCount) {
            strings.addElement(in.readUTF());
            ++i;
        }
        return strings;
    }

    public static void writeStrings(Vector strings, DataOutputStream out) throws IOException {
        out.writeInt(strings.size());
        int i = 0;
        while (i < strings.size()) {
            out.writeUTF((String)strings.elementAt(i));
            ++i;
        }
    }

    public static Hashtable readHashtable(DataInputStream in) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int entryCount = in.readInt();
        int i = 0;
        while (i < entryCount) {
            String key = in.readUTF();
            String value = in.readUTF();
            hashtable.put(key, value);
            ++i;
        }
        return hashtable;
    }

    public static void writeHashtable(Hashtable hashtable, DataOutputStream out) throws IOException {
        out.writeInt(hashtable.size());
        Enumeration e = hashtable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)hashtable.get(key);
            out.writeUTF(key);
            out.writeUTF(value);
        }
    }

    public static Color parseHexColor(String color) {
        return DeepaMehtaUtils.parseHexColor(color, 255);
    }

    public static Color parseHexColor(String color, int alpha) {
        try {
            int r = Integer.parseInt(color.substring(1, 3), 16);
            int g = Integer.parseInt(color.substring(3, 5), 16);
            int b = Integer.parseInt(color.substring(5, 7), 16);
            return new Color(r, g, b, alpha);
        }
        catch (RuntimeException e) {
            throw new DeepaMehtaException("invalid color specification: \"" + color + "\", expected format is \"#rrggbb\"");
        }
    }

    public static Color parseHexColor(String color, String defaultColor) {
        return DeepaMehtaUtils.parseHexColor(color, DeepaMehtaUtils.parseHexColor(defaultColor, Color.white));
    }

    public static Color parseHexColor(String color, Color defaultColor) {
        try {
            if (color == null || color.length() == 0) {
                return defaultColor;
            }
            int r = Integer.parseInt(color.substring(1, 3), 16);
            int g = Integer.parseInt(color.substring(3, 5), 16);
            int b = Integer.parseInt(color.substring(5, 7), 16);
            return new Color(r, g, b);
        }
        catch (RuntimeException e) {
            System.out.println("*** DeepaMehtaUtils.parseHexColor(): invalid color specification: \"" + color + "\" (expected format is #rrggbb) -- default color used");
            return defaultColor;
        }
    }

    public static Date parseDate(String date) {
        return DeepaMehtaUtils.getCalendar(date).getTime();
    }

    public static Point parsePoint(String point) {
        StringTokenizer st = new StringTokenizer(point, ":");
        int x = Integer.parseInt(st.nextToken());
        int y = Integer.parseInt(st.nextToken());
        return new Point(x, y);
    }

    public static boolean isImage(String file) {
        return file.endsWith(".gif") || file.endsWith(".GIF") || file.endsWith(".jpg") || file.endsWith(".JPG") || file.endsWith(".png") || file.endsWith(".PNG");
    }

    public static boolean isHTML(String file) {
        return file.endsWith(".html") || file.endsWith(".HTML") || file.endsWith(".htm") || file.endsWith(".HTM");
    }

    public static void paintLine(Graphics g, int x1, int y1, int x2, int y2, boolean hasDirection) {
        if (hasDirection) {
            g.drawLine(x1, y1 - 1, x2, y2);
            g.drawLine(x1 + 1, y1 - 1, x2, y2);
            g.drawLine(x1 + 2, y1, x2, y2);
            g.drawLine(x1 + 2, y1 + 1, x2, y2);
            g.drawLine(x1 + 1, y1 + 2, x2, y2);
            g.drawLine(x1, y1 + 2, x2, y2);
            g.drawLine(x1 - 1, y1 + 1, x2, y2);
            g.drawLine(x1 - 1, y1, x2, y2);
        } else {
            g.drawLine(x1, y1, x2, y2);
            g.drawLine(x1 + 1, y1, x2 + 1, y2);
            g.drawLine(x1, y1 + 1, x2, y2 + 1);
            g.drawLine(x1 + 1, y1 + 1, x2 + 1, y2 + 1);
        }
    }

    public static String encodeHTMLEntities(String text) {
        return DeepaMehtaUtils.replace(text, '\"', "&quot;");
    }

    public static String encodeHTMLTags(String text) {
        return DeepaMehtaUtils.encodeHTMLTags(text, false);
    }

    public static String encodeHTMLTags(String text, boolean allowSomeTags) {
        StringBuffer quotedText = new StringBuffer(text);
        int i = 0;
        while ((i = quotedText.indexOf("<", i)) != -1) {
            boolean quote;
            if (allowSomeTags) {
                int wordStart = i + 1 < quotedText.length() && quotedText.charAt(i + 1) == '/' ? i + 2 : i + 1;
                String tag = DeepaMehtaUtils.getWord(quotedText, wordStart);
                quote = !ALLOWED_TAGS.contains(tag);
            } else {
                quote = true;
            }
            if (quote) {
                quotedText.replace(i, i + 1, "&lt;");
            }
            ++i;
        }
        return quotedText.toString();
    }

    private static String getWord(StringBuffer str, int fromIndex) {
        int i = fromIndex;
        while (i < str.length() && Character.isLetter(str.charAt(i))) {
            ++i;
        }
        return str.substring(fromIndex, i);
    }

    public static String emailToHTML(String text) {
        String emailRegex = "[\\w\\d-_/\\.]*@+[\\w\\d-_/\\.]*";
        Pattern pattern = Pattern.compile(emailRegex);
        Matcher matcher = pattern.matcher(text);
        int lastIndex = 0;
        StringBuffer html = new StringBuffer();
        while (matcher.find()) {
            html.append(text.substring(lastIndex, matcher.start()));
            int before = matcher.start() - 13;
            if (before >= 0 && "href=\"mailto:".equals(text.substring(before, matcher.start()))) {
                html.append(matcher.group());
            } else {
                html.append("<a href=\"mailto:" + matcher.group() + "\">" + matcher.group() + "</a>");
            }
            lastIndex = matcher.end();
        }
        html.append(text.substring(lastIndex));
        return html.toString();
    }

    public static String weblinksToHTML(String text) {
        String test = "http://[\\w\\d-_/\\.\\?\\%\\@\\$\\;\\&\\=\\\"\\#]*";
        Pattern pattern = Pattern.compile(test);
        Matcher matcher = pattern.matcher(text);
        int lastIndex = 0;
        StringBuffer html = new StringBuffer();
        while (matcher.find()) {
            html.append(text.substring(lastIndex, matcher.start()));
            int before = matcher.start() - 6;
            if (before >= 0 && "href=\"".equals(text.substring(before, matcher.start()))) {
                html.append(matcher.group());
            } else {
                html.append("<a href=\"" + matcher.group() + "\" target=\"blank\">" + matcher.group() + "</a>");
            }
            lastIndex = matcher.end();
        }
        html.append(text.substring(lastIndex));
        return html.toString();
    }

    public static String replaceLF(String text) {
        text = text.replaceAll("\r\n", "<br>");
        text = text.replaceAll("\r", "<br>");
        text = text.replaceAll("\n", "<br>");
        return text;
    }

    public static String transformToHTML(String text) {
        text = DeepaMehtaUtils.emailToHTML(text);
        text = DeepaMehtaUtils.weblinksToHTML(text);
        text = DeepaMehtaUtils.replaceLF(text);
        return text;
    }

    public static String html2xml(String html) {
        StringBuffer xml = new StringBuffer();
        int pos = 0;
        int pos1 = html.indexOf("<img");
        while (pos1 != -1) {
            int pos2 = html.indexOf(">", pos1);
            xml.append(html.substring(pos, pos2 + 1));
            xml.append("</img>");
            pos = pos2 + 1;
            pos1 = html.indexOf("<img", pos);
        }
        xml.append(html.substring(pos));
        html = xml.toString();
        xml.setLength(0);
        pos = 0;
        pos1 = html.indexOf("<br>");
        while (pos1 != -1) {
            xml.append(html.substring(pos, pos1 + 4));
            xml.append("</br>");
            pos = pos1 + 4;
            pos1 = html.indexOf("<br>", pos);
        }
        xml.append(html.substring(pos));
        return xml.toString();
    }

    public static String[] explode(String str) {
        String[] result = new String[2];
        int pos = str.indexOf(":");
        if (pos != -1) {
            result[0] = str.substring(0, pos);
            result[1] = str.substring(pos + 1);
        } else {
            result[0] = str;
        }
        return result;
    }

    public static String replace(String str, char oldChar, String newStr) {
        int pos = str.indexOf(oldChar);
        if (pos == -1) {
            return str;
        }
        StringBuffer result = new StringBuffer();
        int pos0 = 0;
        while (pos != -1) {
            result.append(str.substring(pos0, pos));
            result.append(newStr);
            pos0 = pos + 1;
            pos = str.indexOf(oldChar, pos0);
        }
        result.append(str.substring(pos0));
        return result.toString();
    }

    public static String align(String str) {
        return String.valueOf(str.length() == 1 ? "0" : "") + str;
    }

    public static String unalign(String str) {
        return str.startsWith("0") ? str.substring(1) : str;
    }

    public static String nTimes(String str, int n) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < n) {
            result.append(str);
            ++i;
        }
        return result.toString();
    }

    public static Calendar getCalendar(String date) {
        int year = DeepaMehtaUtils.getYear(date);
        int month = DeepaMehtaUtils.getMonth(date);
        int day = DeepaMehtaUtils.getDay(date);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(year, month - 1, day);
        return cal;
    }

    public static String getDate() {
        return DeepaMehtaUtils.getDate("/");
    }

    public static String getDate(Calendar cal) {
        return DeepaMehtaUtils.getDate(cal, "/");
    }

    public static String getDate(String sep) {
        Calendar cal = Calendar.getInstance();
        return DeepaMehtaUtils.getDate(cal, sep);
    }

    public static String getDate(Calendar cal, String sep) {
        int y = cal.get(1);
        int m = cal.get(2) + 1;
        int d = cal.get(5);
        String date = String.valueOf(y) + sep + (m < 10 ? "0" : "") + m + sep + (d < 10 ? "0" : "") + d;
        return date;
    }

    public static String getTime() {
        return DeepaMehtaUtils.getTime(true);
    }

    public static String getTime(boolean withSecs) {
        return DeepaMehtaUtils.getTime(withSecs, ":");
    }

    public static String getTime(boolean withSecs, String sep) {
        Calendar cal = Calendar.getInstance();
        int h = cal.get(11);
        int m = cal.get(12);
        int s = cal.get(13);
        String time = String.valueOf(h < 10 ? "0" : "") + h + sep + (m < 10 ? "0" : "") + m;
        if (withSecs) {
            time = String.valueOf(time) + sep + (s < 10 ? "0" : "") + s;
        }
        return time;
    }

    public static int getMinutes(String time) {
        int hours = Integer.parseInt(time.substring(0, 2));
        int minutes = Integer.parseInt(time.substring(3, 5));
        return 60 * hours + minutes;
    }

    public static int getDay(String date) {
        int day = Integer.parseInt(date.substring(8));
        return day;
    }

    public static int getMonth(String date) {
        int month = Integer.parseInt(date.substring(5, 7));
        return month;
    }

    public static int getYear(String date) {
        int year = Integer.parseInt(date.substring(0, 4));
        return year;
    }

    public static void reportVMProperties() {
        try {
            String prop = System.getProperty("java.specification.vendor");
            System.out.println("> Java Runtime Environment");
            System.out.println(">    specification: " + prop + "/" + System.getProperty("java.specification.name") + "/" + System.getProperty("java.specification.version"));
            System.out.println(">    VM specification: " + System.getProperty("java.vm.specification.vendor") + "/" + System.getProperty("java.vm.specification.name") + "/" + System.getProperty("java.vm.specification.version"));
            System.out.println(">    VM implementation: " + System.getProperty("java.vm.vendor") + "/" + System.getProperty("java.vm.name") + "/" + System.getProperty("java.vm.version"));
            System.out.println(">    File encoding: " + System.getProperty("file.encoding"));
        }
        catch (Exception e) {
            System.out.println("*** The VM properties can't be reported because this applet is not signed");
        }
    }

    public static void memoryStatus() {
        long memFree = Runtime.getRuntime().freeMemory();
        long memTotal = Runtime.getRuntime().totalMemory();
        System.out.println("> " + DeepaMehtaUtils.mem(memTotal - memFree) + " used (" + DeepaMehtaUtils.mem(memTotal) + " allocated)");
    }

    public static String mem(long bytes) {
        if (bytes < 1024L) {
            return Long.toString(bytes);
        }
        long kBytes = bytes / 1024L;
        if (kBytes < 1000L) {
            return String.valueOf(kBytes) + "K";
        }
        long mBytes = kBytes / 1000L;
        return String.valueOf(mBytes) + "M";
    }

    public static void printStackTrace() {
        DeepaMehtaUtils.printStackTrace(10, 1);
    }

    public static void printStackTrace(int depth) {
        DeepaMehtaUtils.printStackTrace(depth, 1);
    }

    public static void printStackTrace(int depth, int skip) {
    }
}

