/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.topics.helper;

import de.deepamehta.DeepaMehtaConstants;
import de.deepamehta.DeepaMehtaException;
import de.deepamehta.FileServer;
import de.deepamehta.client.X28InitMap;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TopicMapImporter
implements DeepaMehtaConstants {
    private Hashtable idMapping = new Hashtable();
    private int importedTopics;
    private int skippedTopics;
    private int importedAssocs;
    private int skippedAssocs;
    private int importedTopicTypes;
    private int skippedTopicTypes;
    private int importedAssocTypes;
    private int skippedAssocTypes;
    private int importedDocs;
    private int skippedDocs;
    private int importedIcons;
    private int skippedIcons;
    X28InitMap x28InitMap;

    public TopicMapImporter(X28InitMap x28InitMap) {
        this.x28InitMap = x28InitMap;
    }

    public void doImport(File file, int x, int y) {
        Object viewID = null;
        Document doc = null;
        try {
            ZipFile zfile = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String filename = entry.getName();
                InputStream in = zfile.getInputStream(entry);
                if ((filename = filename.replace('\\', '/')).indexOf("/") != -1) continue;
                if (!filename.endsWith(".xml")) {
                    JOptionPane.showMessageDialog(null, "File open failed; view log.");
                    System.exit(1);
                    throw new DeepaMehtaException("unexpected zip entry: " + filename);
                }
                doc = this.getParsedDocument(in);
                this.importTopicMap(doc, "4730");
                in.close();
            }
        }
        catch (IOException e) {
            System.out.println("*** TopicMapImporter.doImport(): " + e);
            JOptionPane.showMessageDialog(null, "File open failed");
            System.exit(1);
            return;
        }
        this.createNewView(doc, x, y);
    }

    private void importFile(InputStream in, String filename) {
        try {
            int bytes_read;
            File file = new File(filename);
            int filetype = FileServer.getFiletype(filename);
            if (file.exists()) {
                if (filetype == 1) {
                    ++this.skippedDocs;
                }
                if (filetype == 2) {
                    ++this.skippedIcons;
                }
                return;
            }
            if (filetype == 1) {
                ++this.importedDocs;
            }
            if (filetype == 2) {
                ++this.importedIcons;
            }
            FileOutputStream out = new FileOutputStream(file);
            byte[] buffer = new byte[32768];
            while ((bytes_read = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, bytes_read);
            }
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            System.out.println("*** TopicMapImporter.importFile(): " + e);
        }
    }

    private void importTopicMap(Document doc, String viewID) {
        boolean cmImport = viewID == null;
        Element root = doc.getDocumentElement();
        if (!cmImport) {
            String origMapID = root.getAttribute("ID");
            this.idMapping.put(origMapID, new IDMapping(viewID, false));
        }
        NodeList topics = root.getElementsByTagName("topic");
        NodeList assocs = root.getElementsByTagName("assoc");
        int i = 0;
        while (i < topics.getLength()) {
            this.importTopic((Element)topics.item(i), viewID);
            ++i;
        }
        i = 0;
        while (i < assocs.getLength()) {
            this.importAssoc((Element)assocs.item(i), viewID);
            ++i;
        }
        System.out.println(String.valueOf(this.importedTopics) + " nodes & " + this.importedAssocs + " edges imported.");
    }

    private void importTopic(Element topic, String viewID) {
        String origID;
        String elementName = topic.getNodeName();
        if (!elementName.equals("topic")) {
            System.out.println("*** TopicMapImporter.importTopic(): element name=\"" + elementName + "\"");
        }
        String topicID = origID = topic.getAttribute("ID");
        String topicName = this.getTopicName(topic);
        ++this.importedTopics;
        String x28Descr = TopicMapImporter.x28FindDescription(topic);
        if (viewID != null && topic.getAttribute("visible").equals("yes")) {
            int x = Integer.parseInt(topic.getAttribute("x"));
            int y = Integer.parseInt(topic.getAttribute("y"));
            String rString = topic.getAttribute("r");
            String gString = topic.getAttribute("g");
            String bString = topic.getAttribute("b");
            if (rString.equals("")) {
                rString = "128";
            }
            int r = Integer.parseInt(rString);
            if (gString.equals("")) {
                gString = "128";
            }
            int g = Integer.parseInt(gString);
            if (bString.equals("")) {
                bString = "128";
            }
            int b = Integer.parseInt(bString);
            Color color = new Color(r, g, b);
            this.x28InitMap.createNode(topicID, topicName, x28Descr, x, y, color);
        }
    }

    private void importAssoc(Element assoc, String viewID) {
        String elementName = assoc.getNodeName();
        if (elementName.equals("assoc")) {
            String origID;
            String assocID = origID = assoc.getAttribute("ID");
            NodeList assocrls = assoc.getElementsByTagName("assocrl");
            Element element = (Element)assocrls.item(0);
            String roletype1 = element.getAttribute("anchrole");
            String topicID1 = TopicMapImporter.getTextOfChildNode(element);
            element = (Element)assocrls.item(1);
            String roletype2 = element.getAttribute("anchrole");
            String topicID2 = TopicMapImporter.getTextOfChildNode(element);
            ++this.importedAssocs;
            String x28Descr = TopicMapImporter.x28FindDescription(assoc);
            if (viewID != null && assoc.getAttribute("visible").equals("yes")) {
                String rString = assoc.getAttribute("r");
                String gString = assoc.getAttribute("g");
                String bString = assoc.getAttribute("b");
                if (rString.equals("")) {
                    rString = "128";
                }
                int r = Integer.parseInt(rString);
                if (gString.equals("")) {
                    gString = "128";
                }
                int g = Integer.parseInt(gString);
                if (bString.equals("")) {
                    bString = "128";
                }
                int b = Integer.parseInt(bString);
                Color color = new Color(r, g, b);
                this.x28InitMap.createEdge(assocID, "", x28Descr, topicID1, topicID2, color);
            }
        } else {
            System.out.println("*** TopicMapImporter.importAssoc(): element name=\"" + elementName + "\"");
        }
    }

    private Document getParsedDocument(InputStream in) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder parser = dbf.newDocumentBuilder();
            return parser.parse(new InputSource(in));
        }
        catch (Exception e) {
            System.out.println("### TopicMapImporter.getParsedDocument: ");
            e.printStackTrace();
            return null;
        }
    }

    private String getTopicName(Element topic) {
        Element topname = (Element)topic.getElementsByTagName("topname").item(0);
        return TopicMapImporter.getTextOfChildNode(topname, "basename");
    }

    private static String getTextOfChildNode(Node node) {
        Node child = node.getFirstChild();
        return child != null ? child.getNodeValue() : "";
    }

    private static String getTextOfChildNode(Element current, String elementName) {
        Node nameItem = current.getElementsByTagName(elementName).item(0);
        return TopicMapImporter.getTextOfChildNode(nameItem);
    }

    private static Hashtable getProperties(Element el) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        NodeList nodes = el.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Element elem;
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && (elem = (Element)node).getTagName().equals("property")) {
                String propName = elem.getAttribute("name");
                String propVal = TopicMapImporter.getTextOfChildNode(node);
                props.put(propName, propVal == null ? "" : propVal);
            }
            ++i;
        }
        return props;
    }

    private static String x28FindDescription(Element el) {
        Hashtable props = new Hashtable();
        NodeList nodes = el.getChildNodes();
        String x28Descr = null;
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                Element elem = (Element)node;
                if (elem.getTagName().equals("description")) {
                    x28Descr = TopicMapImporter.getTextOfChildNode(node);
                } else if (elem.getTagName().equals("property")) {
                    String propName = elem.getAttribute("name");
                    x28Descr = TopicMapImporter.getTextOfChildNode(node);
                    propName.equals("Description");
                }
            }
            ++i;
        }
        return x28Descr;
    }

    private void createNewView(Document doc, int x, int y) {
        Element docElement = doc.getDocumentElement();
        String topicmapName = docElement.getAttribute("name");
        Hashtable props = TopicMapImporter.getProperties(docElement);
    }

    private void mapTopicIDs(NodeList topics) {
        int i = 0;
        while (i < topics.getLength()) {
            Element topic = (Element)topics.item(i);
            String string = this.getTopicName(topic);
            ++i;
        }
    }

    public void report() {
        System.out.println("> " + this.importedTopics + " topics imported, " + this.skippedTopics + " skipped");
        System.out.println("> " + this.importedAssocs + " associations imported, " + this.skippedAssocs + " skipped");
        System.out.println("> " + this.importedTopicTypes + " topic types imported, " + this.skippedTopicTypes + " skipped");
        System.out.println("> " + this.importedAssocTypes + " association types imported, " + this.skippedAssocTypes + " skipped");
        System.out.println("> " + this.importedDocs + " documents imported, " + this.skippedDocs + " skipped");
        System.out.println("> " + this.importedIcons + " icons imported, " + this.skippedIcons + " skipped");
    }

    private class IDMapping {
        private String mappedID;
        private boolean unified;

        private IDMapping(String mappedID, boolean unified) {
            this.mappedID = mappedID;
            this.unified = unified;
        }

        public String toString() {
            return "(mapped ID: " + this.mappedID + ", unified: " + this.unified + ")";
        }

        private boolean unified() {
            return this.unified;
        }

        private String mappedID() {
            return this.mappedID;
        }
    }
}

