/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.topics.helper;

import de.deepamehta.DeepaMehtaConstants;
import de.deepamehta.FileServer;
import de.deepamehta.client.X28Edge;
import de.deepamehta.client.X28Node;
import de.deepamehta.topics.helper.ArchiveFileCollector;
import java.awt.Color;
import java.awt.Point;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class TopicMapExporter
implements DeepaMehtaConstants {
    Hashtable nodes;
    Hashtable edges;

    public TopicMapExporter(Hashtable nodes, Hashtable edges) {
        this.nodes = nodes;
        this.edges = edges;
    }

    public File createTopicmapArchive(String fileBasename) throws IOException {
        File archiveFile = new File(String.valueOf(FileServer.repositoryPath(1)) + fileBasename + ".zip");
        if (fileBasename.substring(fileBasename.length() - 4, fileBasename.length()).equals(".zip")) {
            archiveFile = new File(fileBasename);
            System.out.println(archiveFile);
        }
        FileServer.createDirectory(archiveFile);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(archiveFile));
        ArchiveFileCollector collector = new ArchiveFileCollector();
        this.exportViewMode(out, fileBasename, collector);
        collector.export(out);
        out.close();
        return archiveFile;
    }

    private void exportViewMode(ZipOutputStream out, String filename, ArchiveFileCollector collector) {
        try {
            out.putNextEntry(new ZipEntry("savefile.xml"));
            SAXTransformerFactory saxTFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            TransformerHandler handler = saxTFactory.newTransformerHandler();
            handler.setResult(new StreamResult(out));
            handler.startDocument();
            TopicMapExporter.startElement(handler, "topicmap", null);
            Enumeration nodesEnum = this.nodes.elements();
            TopicMapExporter.exportTopics(nodesEnum, handler, true, collector);
            Enumeration edgesEnum = this.edges.elements();
            TopicMapExporter.exportAssociations(edgesEnum, handler, true, collector);
            TopicMapExporter.endElement(handler, "topicmap");
            handler.endDocument();
        }
        catch (Throwable e) {
            System.out.println("*** TopicMapExporter.exportViewMode(): " + e);
            e.printStackTrace();
        }
    }

    public static void exportTopics(Enumeration topics, ContentHandler handler, boolean visible, ArchiveFileCollector collector) throws SAXException {
        while (topics.hasMoreElements()) {
            X28Node topic = (X28Node)topics.nextElement();
            TopicMapExporter.exportTopic(topic, handler, visible, collector);
        }
    }

    public static void exportAssociations(Enumeration assocs, ContentHandler handler, boolean visible, ArchiveFileCollector collector) throws SAXException {
        while (assocs.hasMoreElements()) {
            X28Edge assoc = (X28Edge)assocs.nextElement();
            TopicMapExporter.exportAsssociation(assoc, handler, visible, collector);
        }
    }

    private static void exportTopic(X28Node topic, ContentHandler handler, boolean visible, ArchiveFileCollector collector) throws SAXException {
        Hashtable<String, Object> attribs = new Hashtable<String, Object>();
        attribs.put("ID", topic.getID());
        attribs.put("visible", visible ? "yes" : "no");
        Color color = topic.getColor();
        attribs.put("r", new Integer(color.getRed()));
        attribs.put("g", new Integer(color.getGreen()));
        attribs.put("b", new Integer(color.getBlue()));
        if (visible) {
            Point p = topic.getGeometry();
            attribs.put("x", new Integer(p.x));
            attribs.put("y", new Integer(p.y));
        }
        TopicMapExporter.startElement(handler, "topic", attribs);
        TopicMapExporter.startElement(handler, "topname", null);
        TopicMapExporter.startElement(handler, "basename", null);
        TopicMapExporter.characters(handler, topic.getName());
        TopicMapExporter.endElement(handler, "basename");
        TopicMapExporter.endElement(handler, "topname");
        TopicMapExporter.startElement(handler, "description", null);
        TopicMapExporter.characters(handler, topic.getVerbal());
        TopicMapExporter.endElement(handler, "description");
        TopicMapExporter.endElement(handler, "topic");
    }

    public static void exportAsssociation(X28Edge assoc, ContentHandler handler, boolean visible, ArchiveFileCollector collector) throws SAXException {
        Hashtable<String, Object> attribs = new Hashtable<String, Object>();
        attribs.put("ID", assoc.getID());
        attribs.put("visible", visible ? "yes" : "no");
        Color color = assoc.getColor();
        attribs.put("r", new Integer(color.getRed()));
        attribs.put("g", new Integer(color.getGreen()));
        attribs.put("b", new Integer(color.getBlue()));
        TopicMapExporter.startElement(handler, "assoc", attribs);
        TopicMapExporter.startElement(handler, "description", null);
        TopicMapExporter.characters(handler, assoc.getVerbal());
        TopicMapExporter.endElement(handler, "description");
        attribs = new Hashtable();
        attribs.put("anchrole", "tt-topic1");
        TopicMapExporter.startElement(handler, "assocrl", attribs);
        TopicMapExporter.characters(handler, assoc.getTopicID1());
        TopicMapExporter.endElement(handler, "assocrl");
        attribs.put("anchrole", "tt-topic2");
        TopicMapExporter.startElement(handler, "assocrl", attribs);
        TopicMapExporter.characters(handler, assoc.getTopicID2());
        TopicMapExporter.endElement(handler, "assocrl");
        TopicMapExporter.endElement(handler, "assoc");
    }

    public static void startElement(ContentHandler handler, String tagName, Hashtable attributes) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        if (attributes != null) {
            Enumeration attribKeys = attributes.keys();
            while (attribKeys.hasMoreElements()) {
                String key = attribKeys.nextElement().toString();
                String value = attributes.get(key).toString();
                attrs.addAttribute("", "", key, "CDATA", value);
            }
        }
        handler.startElement("", "", tagName, attrs);
    }

    public static void endElement(ContentHandler handler, String tagName) throws SAXException {
        handler.endElement("", "", tagName);
    }

    public static void characters(ContentHandler handler, String string) throws SAXException {
        char[] chars = string.toCharArray();
        if (handler instanceof LexicalHandler) {
            ((LexicalHandler)((Object)handler)).startCDATA();
            handler.characters(chars, 0, chars.length);
            ((LexicalHandler)((Object)handler)).endCDATA();
        } else {
            handler.characters(chars, 0, chars.length);
        }
    }
}

