/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.topics.helper;

import de.deepamehta.DeepaMehtaConstants;
import de.deepamehta.FileServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ArchiveFileCollector
implements DeepaMehtaConstants {
    Hashtable documents = new Hashtable();
    Hashtable icons = new Hashtable();

    public void putIcon(String iconName) {
        if (iconName != null && !iconName.equals("")) {
            this.icons.put(iconName, new File("icons/" + iconName));
        }
    }

    public void putDocument(String docName) {
        if (docName != null && !docName.equals("")) {
            this.documents.put(docName, new File(String.valueOf(FileServer.repositoryPath(1)) + docName));
        }
    }

    public void export(ZipOutputStream zout) {
        try {
            this.exportFiles(this.documents, zout);
            this.exportFiles(this.icons, zout);
        }
        catch (IOException e) {
            System.out.println("### ArchiveFileCollector.export: " + e);
        }
    }

    private void exportFiles(Hashtable hash, ZipOutputStream zout) throws IOException {
        byte[] buffer = new byte[4096];
        Enumeration files = hash.elements();
        while (files.hasMoreElements()) {
            File file = (File)files.nextElement();
            try {
                int bytes_read;
                FileInputStream in = new FileInputStream(file);
                ZipEntry entry = new ZipEntry(file.getPath());
                zout.putNextEntry(entry);
                while ((bytes_read = in.read(buffer)) != -1) {
                    zout.write(buffer, 0, bytes_read);
                }
                in.close();
            }
            catch (FileNotFoundException e) {
                System.out.println("### ArchiveFileCollector.exportFiles: File " + file.getName() + " not found!");
            }
        }
    }
}

