/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.client;

import de.deepamehta.DeepaMehtaConstants;
import de.deepamehta.client.X28Node;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.StyledDocument;

public class X28PasteWindow
implements DeepaMehtaConstants {
    Hashtable nodes = new Hashtable();
    Hashtable edges = new Hashtable();
    JFrame pasteWindow;
    private JTextPane textDisplay;
    AbstractDocument doc;
    JPanel toolbar;
    JButton pasteButton;
    JButton continueButton;
    JTextArea or = new JTextArea("   or   ");
    JTextArea or2 = new JTextArea("        ");
    JTextArea dropFile = new JTextArea(" \n        Drop File       \n           here\n ");
    boolean blink = true;
    String x28Filename = "";
    DefaultEditorKit.PasteAction pasteAction = new DefaultEditorKit.PasteAction();
    String[][] columns = new String[500][2];
    int[] colons = new int[500];
    int[] commas = new int[500];
    int[] blanks = new int[500];
    int newNodes;
    boolean pasteFinished = false;
    private DefaultListModel listModel = new DefaultListModel();
    private JList list = new JList(this.listModel);
    private TransferHandler handler = new TransferHandler(){

        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            X28PasteWindow.this.dropFile.setBackground(Color.decode("#CCDDEE"));
            support.setDropAction(1);
            return true;
        }

        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            Transferable t = support.getTransferable();
            try {
                List l = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                for (File f : l) {
                    X28PasteWindow.this.x28Filename = f.getAbsolutePath();
                    if (f.getName().length() > 25) {
                        X28PasteWindow.this.dropFile.setText(f.getName().substring(1, 25));
                        continue;
                    }
                    X28PasteWindow.this.dropFile.setText(f.getName());
                }
            }
            catch (UnsupportedFlavorException ex) {
                return false;
            }
            catch (IOException ex) {
                return false;
            }
            X28PasteWindow.this.pasteButton.setEnabled(false);
            X28PasteWindow.this.or.setEnabled(false);
            X28PasteWindow.this.continueButton.setEnabled(true);
            X28PasteWindow.this.pasteFinished = true;
            t.notifyAll();
            X28PasteWindow.this.close();
            return true;
        }
    };

    public X28PasteWindow() {
        this.pasteWindow = new JFrame("Paste, drop or type input here ...");
        this.pasteWindow.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                X28PasteWindow.this.close();
            }
        });
        this.pasteWindow.setSize(660, 680);
        this.pasteWindow.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane();
        this.textDisplay = new JTextPane();
        scroll.getViewport().add(this.textDisplay);
        StyledDocument styledDoc = this.textDisplay.getStyledDocument();
        if (styledDoc instanceof AbstractDocument) {
            this.doc = (AbstractDocument)((Object)styledDoc);
        } else {
            System.err.println("Text pane's document isn't an AbstractDocument!");
            System.exit(-1);
        }
        this.textDisplay.setEditable(true);
        this.textDisplay.setCaretPosition(0);
        this.toolbar = new JPanel();
        this.pasteButton = new JButton("<html><body><center>Press here<br />to Paste</center></body></html>");
        this.pasteButton.setToolTipText("Press this button to Paste from Clipboard");
        this.dropFile.setToolTipText("Drag & Drop an Existing File here");
        this.or.setBackground(DEFAULT_BGCOLOR_MESSAGE);
        this.or2.setBackground(DEFAULT_BGCOLOR_MESSAGE);
        this.continueButton = new JButton("Continue");
        this.pasteButton.setActionCommand("Paste");
        class MyDocumentListener
        implements DocumentListener {
            MyDocumentListener() {
            }

            public void insertUpdate(DocumentEvent e) {
                X28PasteWindow.this.continueButton.setEnabled(true);
            }

            public void removeUpdate(DocumentEvent e) {
            }

            public void changedUpdate(DocumentEvent e) {
            }
        }
        this.doc.addDocumentListener(new MyDocumentListener());
        this.toolbar.add(this.pasteButton);
        this.toolbar.add(this.or);
        this.toolbar.add(this.dropFile);
        this.toolbar.add(this.or2);
        this.list.getSelectionModel().setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.dropFile.setTransferHandler(this.handler);
        class MyActionAdapter
        implements ActionListener {
            MyActionAdapter() {
            }

            public void actionPerformed(ActionEvent a) {
                if (a.getActionCommand().equals("Paste")) {
                    X28PasteWindow.this.pasteAction.actionPerformed(a);
                } else if (a.getActionCommand().equals("Continue")) {
                    X28PasteWindow.this.newNodes = X28PasteWindow.this.separateRecords();
                    X28PasteWindow.this.heuristics(X28PasteWindow.this.newNodes);
                    X28PasteWindow.this.createNodes(X28PasteWindow.this.newNodes);
                    X28PasteWindow.this.close();
                } else {
                    System.out.println(a.getActionCommand().toString());
                }
            }
        }
        MyActionAdapter actionlistener = new MyActionAdapter();
        this.pasteButton.addActionListener(actionlistener);
        this.continueButton.addActionListener(actionlistener);
        this.toolbar.add(this.continueButton);
        this.continueButton.setEnabled(false);
        this.pasteWindow.add((Component)scroll, "Center");
        this.pasteWindow.add((Component)this.toolbar, "South");
        Point whereOnScreen = new Point(300, 50);
        this.pasteWindow.setLocation(whereOnScreen);
        this.pasteWindow.setVisible(true);
    }

    int separateRecords() {
        String rawText = this.textDisplay.getText();
        String newLine = System.getProperty("line.separator");
        int newLineLength = newLine.length();
        char tabChar = "\t".charAt(0);
        char colonChar = ":".charAt(0);
        char commaChar = ",".charAt(0);
        char blankChar = " ".charAt(0);
        rawText = rawText.concat(newLine).concat(newLine);
        int len = rawText.length();
        int i = 0;
        int numRec = 0;
        this.commas[0] = -1;
        int col = 0;
        StringBuffer recordBuffer = new StringBuffer();
        int offsetOfRecord = 0 - newLineLength;
        boolean cont = true;
        while (cont) {
            int j = i + newLineLength;
            String testForNewLine = rawText.substring(i, j);
            if (testForNewLine.equals(newLine)) {
                this.columns[numRec][col] = recordBuffer.toString();
                recordBuffer = new StringBuffer();
                if (col != 0 || !this.columns[numRec][0].isEmpty()) {
                    ++numRec;
                }
                this.commas[numRec] = -1;
                if (numRec == 499) {
                    cont = false;
                    JOptionPane.showMessageDialog(null, "Truncated to 500 items, sorry\n");
                }
                col = 0;
                offsetOfRecord = i + newLineLength;
                i = j;
            } else {
                char testForTab = rawText.charAt(i);
                if (testForTab != tabChar) {
                    recordBuffer.append(testForTab);
                    int posOfFirstComma = this.commas[numRec];
                    if (posOfFirstComma == -1 && testForTab == commaChar) {
                        this.commas[numRec] = posOfFirstComma = i - offsetOfRecord;
                    }
                    ++i;
                } else {
                    this.columns[numRec][col] = recordBuffer.toString();
                    recordBuffer = new StringBuffer();
                    col = 1;
                    ++i;
                }
            }
            if (i < len - 1) continue;
            cont = false;
        }
        if (numRec > 499) {
            numRec = 500;
        }
        return numRec;
    }

    void heuristics(int numRec) {
        block12: {
            boolean noTabs;
            block11: {
                noTabs = true;
                int i = 0;
                while (i <= numRec) {
                    if (this.columns[i][1] != null) {
                        noTabs = false;
                    }
                    ++i;
                }
                boolean manyEarlyCommas = false;
                int earlyCommasCount = 0;
                int i2 = 0;
                while (i2 <= numRec) {
                    int commaPos = this.commas[i2];
                    if (commaPos > -1 && commaPos < 30) {
                        ++earlyCommasCount;
                    }
                    ++i2;
                }
                double commaPercentage = (double)earlyCommasCount / (double)numRec;
                if (commaPercentage > 0.8) {
                    manyEarlyCommas = true;
                }
                if (!noTabs || !manyEarlyCommas) break block11;
                int i3 = 0;
                while (i3 <= numRec) {
                    String first;
                    this.columns[i3][1] = first = this.columns[i3][0];
                    if (first != null) {
                        int commaPos = this.commas[i3];
                        if (commaPos == -1) {
                            commaPos = first.length();
                        }
                        if (commaPos > 25) {
                            commaPos = 25;
                        }
                        this.columns[i3][0] = first.substring(0, commaPos);
                    }
                    ++i3;
                }
                break block12;
            }
            if (!noTabs) break block12;
            int i = 0;
            while (i <= numRec) {
                String first;
                this.columns[i][1] = first = this.columns[i][0];
                if (first != null && first.length() > 30) {
                    this.columns[i][0] = String.valueOf(i + 1);
                }
                ++i;
            }
        }
    }

    void createNodes(int newNodes) {
        int maxVert = (int)Math.sqrt(newNodes / 3);
        if (maxVert < 10) {
            maxVert = 10;
        }
        int j = 0;
        int i = 0;
        while (i < newNodes) {
            String topicName = this.columns[i][0];
            String verbal = this.columns[i][1];
            if (verbal == null) {
                verbal = "";
            }
            if (!topicName.isEmpty() || !verbal.isEmpty()) {
                int id = 100 + j;
                String topicID = String.valueOf(id);
                int y = 40 + j % maxVert * 50 + j / maxVert * 5;
                int x = 40 + j / maxVert * 150;
                Point p = new Point(x, y);
                X28Node topic = new X28Node(topicID, topicName, verbal, p, Color.gray);
                this.nodes.put(topicID, topic);
                ++j;
            }
            ++i;
        }
        this.edges.clear();
        this.pasteFinished = true;
    }

    void close() {
        this.list.removeListSelectionListener(null);
        this.pasteWindow.dispose();
    }

    public Hashtable getX28Nodes() {
        return this.nodes;
    }

    public Hashtable getX28Edges() {
        return this.edges;
    }

    public boolean isFinished() {
        return this.pasteFinished;
    }

    public String getX28Filename() {
        return this.x28Filename;
    }
}

