/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.client;

import de.deepamehta.client.GraphNode;
import de.deepamehta.client.PresentationService;
import de.deepamehta.client.X28Edge;
import de.deepamehta.client.X28Node;
import de.deepamehta.topics.helper.TopicMapImporter;
import java.awt.Color;
import java.awt.Point;
import java.io.File;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class X28InitMap {
    Hashtable nodes = new Hashtable();
    Hashtable edges = new Hashtable();
    private JButton OK;
    private JButton cancel;

    public X28InitMap(PresentationService ps) {
        JOptionPane macWarning = new JOptionPane();
        Object[] macOptions = new Object[]{"OK, exit.", "Proceed anyway"};
        String filename = ps.x28Filename;
        if (filename.isEmpty()) {
            int macResponse;
            if (System.getProperty("os.name").equals("Mac OS X") && (macResponse = JOptionPane.showOptionDialog(null, "On your Mac, the File Chooser might not work and you \nmight need to Force Quit the DeepaMehta application.\n\nPlease use the launcher or the command line.\n", "Warning", -1, 2, null, macOptions, macOptions[0])) != 1) {
                System.exit(0);
            }
            filename = ps.chooseFile();
        }
        System.out.println("Opening " + filename);
        File file = new File(filename);
        TopicMapImporter importer = new TopicMapImporter(this);
        importer.doImport(file, 300, 300);
        ps.x28SetFilename(filename);
    }

    public void createNode(String topicID, String topicName, String verbal, int x, int y, Color color) {
        Point p = new Point(x, y);
        if (color.equals(null)) {
            color = Color.gray;
        }
        X28Node topic = new X28Node(topicID, topicName, verbal, p, color);
        this.nodes.put(topicID, topic);
    }

    public void createEdge(String assocID, String assocName, String verbal, String topicID1, String topicID2, Color color) {
        GraphNode topic1 = (GraphNode)this.nodes.get(topicID1);
        GraphNode topic2 = (GraphNode)this.nodes.get(topicID2);
        if (topic1 != null && topic2 != null) {
            if (color.equals(null)) {
                color = Color.gray;
            }
            if (verbal == null) {
                verbal = "";
            }
            X28Edge assoc = new X28Edge(assocID, assocName, verbal, topic1, topic2, color);
            this.edges.put(assocID, assoc);
            topic1.addEdge(assoc);
            assoc.setTopicID1(topicID1);
            this.nodes.put(topicID1, topic1);
            topic2.addEdge(assoc);
            assoc.setTopicID2(topicID2);
            this.nodes.put(topicID2, topic2);
        } else {
            System.out.println("GraphEdge NICHT erzeugt " + assocID);
        }
    }

    public Hashtable getX28Nodes() {
        return this.nodes;
    }

    public Hashtable getX28Edges() {
        return this.edges;
    }
}

