/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.client;

import de.deepamehta.DeepaMehtaConstants;
import de.deepamehta.DeepaMehtaException;
import de.deepamehta.client.DeepaMehtaClientUtils;
import de.deepamehta.client.GraphPanelControler;
import de.deepamehta.util.DeepaMehtaUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

class TextEditorPanel
extends JPanel
implements ActionListener,
DocumentListener,
DeepaMehtaConstants {
    StyledEditorKit.BoldAction boldSpecial = new StyledEditorKit.BoldAction();
    JButton x28Button;
    CaretListener myCaretAdapter;
    int x28Mark;
    int x28Dot;
    String textToAdd = "";
    boolean doubleClicked = false;
    GraphPanelControler controler;
    private int editorType;
    private JTextComponent textComponent;
    private JScrollPane scrollPane;
    boolean showToolbar;
    boolean editableOrClickable = true;
    JPanel toolbar;
    private boolean isDirty;
    private static Logger logger = Logger.getLogger("de.deepamehta");

    TextEditorPanel(int editorType, HyperlinkListener listener, GraphPanelControler controler, boolean showToolbar) {
        this.editorType = editorType;
        this.showToolbar = showToolbar;
        this.controler = controler;
        this.setLayout(new BorderLayout());
        switch (editorType) {
            case 1: {
                this.textComponent = new JTextArea();
                this.scrollPane = new JScrollPane(this.textComponent);
                this.add(this.scrollPane);
                break;
            }
            case 2: {
                this.textComponent = new JTextPane();
                this.textComponent.setTransferHandler(new TextTransferHandler());
                listener = new X28HyperlinkListener();
                ((JEditorPane)this.textComponent).addHyperlinkListener(listener);
                if (showToolbar) {
                    this.toolbar = new JPanel();
                    Hashtable actions = DeepaMehtaClientUtils.createActionTable(this.textComponent);
                    this.toolbar.setBackground(COLOR_PROPERTY_PANEL);
                    this.addButton(this.toolbar, this.boldSpecial, actions);
                    this.addButton(this.toolbar, new StyledEditorKit.ItalicAction(), actions);
                    this.addButton(this.toolbar, new StyledEditorKit.UnderlineAction(), actions);
                    this.x28Button = new JButton("B+");
                    String x28Command = "AddToLabel";
                    MyActionAdapter actionlistener = new MyActionAdapter();
                    this.x28Button.addActionListener(actionlistener);
                    this.x28Button.setActionCommand(x28Command);
                    this.x28Button.setToolTipText("Bold Special: bold and add the marked text to the node's label above and on the map");
                    this.toolbar.add((Component)this.x28Button, "South");
                    this.x28Button.setEnabled(true);
                    this.add((Component)this.toolbar, "South");
                    this.myCaretAdapter = new MyCaretAdapter();
                    this.textComponent.addCaretListener(this.myCaretAdapter);
                    this.textComponent.addMouseListener(new MouseAdapter(){

                        public void mousePressed(MouseEvent e) {
                            TextEditorPanel.this.doubleClicked = e.getClickCount() == 2;
                        }

                        public void mouseReleased(MouseEvent e) {
                        }
                    });
                    this.textComponent.addMouseMotionListener(new MouseMotionAdapter(){

                        public void mouseDragged(MouseEvent e) {
                        }
                    });
                    this.textComponent.setEditable(this.editableOrClickable);
                    System.out.println("Toggle to " + this.editableOrClickable + " (initial)");
                }
                this.scrollPane = new JScrollPane(this.textComponent);
                this.add(this.scrollPane);
                break;
            }
            case 3: {
                this.textComponent = new JTextField();
                ((JTextField)this.textComponent).addActionListener(this);
                this.add(this.textComponent);
                break;
            }
            default: {
                throw new DeepaMehtaException("unexpected text editor type: " + editorType);
            }
        }
        try {
            this.textComponent.setDragEnabled(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public void x28ProcessClicks() {
        int totalLen = this.textComponent.getText().length();
        int selectedLen = this.x28Dot - this.x28Mark;
        if (selectedLen < 0) {
            selectedLen = -selectedLen;
            this.x28Mark = this.x28Dot;
        }
        try {
            this.textToAdd = this.textComponent.getText(this.x28Mark, selectedLen);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
            this.textToAdd = "";
        }
        this.textToAdd.isEmpty();
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (e.getSource() != this.textComponent) {
            throw new DeepaMehtaException("unexpected event source: " + e.getSource() + " (action command: \"" + actionCommand + "\")");
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.setDirty("style change");
    }

    public void insertUpdate(DocumentEvent e) {
        this.setDirty("typing");
    }

    public void removeUpdate(DocumentEvent e) {
        this.setDirty("deleting");
    }

    String getText() {
        return this.getTextComponent().getText();
    }

    JTextComponent getTextComponent() {
        return this.textComponent;
    }

    JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    boolean isDirty() {
        return this.isDirty;
    }

    public void setEnabled(boolean enabled) {
        this.textComponent.setEnabled(enabled);
        this.textComponent.setEditable(enabled);
        if (this.showToolbar) {
            this.toolbar.setVisible(enabled);
        }
    }

    public void x28ToggleHyp() {
        this.editableOrClickable = !this.editableOrClickable;
        this.textComponent.setEditable(this.editableOrClickable);
    }

    public void requestFocus() {
        this.textComponent.requestFocus();
    }

    void setText(String text) {
        this.setText(text, null, this);
    }

    void setText(String text, String baseURL, DocumentListener documentListener) {
        this.textComponent.getDocument().removeDocumentListener(documentListener);
        if (this.editorType == 2) {
            ((JEditorPane)this.textComponent).setContentType("text/html");
            try {
                if (baseURL != null && !baseURL.equals("")) {
                    ((HTMLDocument)this.textComponent.getDocument()).setBase(new URL(baseURL));
                }
            }
            catch (MalformedURLException mue) {
                logger.warning("invalid base URL: " + mue);
            }
            try {
                text = this.fixMissingParagraphTag(text);
                this.textComponent.setText(text);
            }
            catch (Throwable e) {
                this.textComponent.setText("<html><body><font color=#FF0000>Page can't be displayed</font></body></html>");
                logger.warning("error while HTML rendering: " + e);
            }
        } else {
            this.textComponent.setText(text);
        }
        this.textComponent.getDocument().addDocumentListener(documentListener);
    }

    private void addButton(JPanel container, Action action, Hashtable actions) {
        String actionName = (String)action.getValue("Name");
        String actionCommand = (String)action.getValue("ActionCommandKey");
        String biu = actionName.substring(5, 6).toUpperCase();
        JButton button = new JButton("<html><body><" + biu + ">" + biu + "</" + biu + "></body></html>");
        if (biu.equals("B")) {
            button.setToolTipText("Bold");
        }
        if (biu.equals("I")) {
            button.setToolTipText("Italic");
        }
        if (biu.equals("U")) {
            button.setToolTipText("Underline");
        }
        button.setActionCommand(actionCommand);
        button.addActionListener(DeepaMehtaClientUtils.getActionByName(actionName, actions));
        container.add(button);
    }

    private String fixMissingParagraphTag(String text) {
        int bs = text.indexOf("<body>");
        if (bs == -1) {
            text.length();
            return text;
        }
        int ws = bs + 6;
        char c = text.charAt(ws);
        while (Character.isWhitespace(c)) {
            c = text.charAt(++ws);
        }
        int p = ws;
        if (text.substring(p, p + 3).equals("<p>")) {
            logger.fine("no need to fix\n" + text);
            return text;
        }
        int be = text.indexOf("</body>", p);
        StringBuffer fixedText = new StringBuffer(text);
        fixedText.insert(be, "</p>");
        fixedText.insert(p, "<p>");
        logger.fine(String.valueOf(text) + "\n                fixed to\n" + fixedText);
        return fixedText.toString();
    }

    private void setDirty(String message) {
        if (!this.isDirty) {
            logger.info("text editor content changed (by " + message + ")");
            this.isDirty = true;
        }
    }

    class MyActionAdapter
    implements ActionListener {
        MyActionAdapter() {
        }

        public void actionPerformed(ActionEvent a) {
            if (a.getActionCommand().equals("AddToLabel")) {
                TextEditorPanel.this.boldSpecial.actionPerformed(a);
                TextEditorPanel.this.controler.x28AddToLabel(TextEditorPanel.this.textToAdd);
            }
        }
    }

    class MyCaretAdapter
    implements CaretListener {
        MyCaretAdapter() {
        }

        public void caretUpdate(CaretEvent e) {
            TextEditorPanel.this.x28Mark = e.getMark();
            TextEditorPanel.this.x28Dot = e.getDot();
            TextEditorPanel.this.x28ProcessClicks();
        }
    }

    private class TextTransferHandler
    extends TransferHandler {
        private JTextComponent source;
        private boolean shouldRemove;
        Position p0 = null;
        Position p1 = null;

        private TextTransferHandler() {
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            return true;
        }

        public boolean importData(JComponent c, Transferable t) {
            boolean hasFilelistFlavor;
            boolean hasStringFlavor;
            block16: {
                if (c != TextEditorPanel.this.textComponent) {
                    logger.warning("c=" + c);
                }
                DataFlavor[] flavors = t.getTransferDataFlavors();
                hasStringFlavor = t.isDataFlavorSupported(DataFlavor.stringFlavor);
                boolean hasImageFlavor = t.isDataFlavorSupported(DataFlavor.imageFlavor);
                hasFilelistFlavor = t.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
                logger.info("importing data to text panel (" + flavors.length + " flavors)" + "    string flavor supported: " + hasStringFlavor + "    image flavor supported: " + hasImageFlavor + "    filelist flavor supported: " + hasFilelistFlavor);
                if (this.source != TextEditorPanel.this.textComponent || TextEditorPanel.this.textComponent.getCaretPosition() < this.p0.getOffset() || TextEditorPanel.this.textComponent.getCaretPosition() > this.p1.getOffset()) break block16;
                this.shouldRemove = false;
                logger.info("dropping on top of the selected text is not allowed -- import canceled");
                return true;
            }
            try {
                if (hasStringFlavor) {
                    String data = (String)t.getTransferData(DataFlavor.stringFlavor);
                    int pos = TextEditorPanel.this.textComponent.getCaretPosition();
                    if (DeepaMehtaUtils.isImage(data)) {
                        HTMLEditorKit kit = (HTMLEditorKit)((JEditorPane)TextEditorPanel.this.textComponent).getEditorKit();
                        HTMLDocument doc = (HTMLDocument)TextEditorPanel.this.textComponent.getDocument();
                        String html = "<img src=\"" + data + "\"></img>";
                        kit.insertHTML(doc, pos, html, 0, 0, HTML.Tag.IMG);
                        logger.info("inserting <img> tag \"" + html + "\"");
                    } else {
                        TextEditorPanel.this.textComponent.getDocument().insertString(pos, data, null);
                        logger.info("inserting regular text \"" + data + "\"");
                    }
                } else if (hasFilelistFlavor) {
                    List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    logger.info("    " + files.size() + " files:");
                    int i = 0;
                    while (i < files.size()) {
                        File file = (File)files.get(i);
                        String filename = file.getName();
                        logger.info("    " + file);
                        if (DeepaMehtaUtils.isHTML(filename)) {
                            String html = DeepaMehtaUtils.readFile(file);
                            TextEditorPanel.this.textComponent.setText(html);
                            TextEditorPanel.this.textComponent.setCaretPosition(0);
                            logger.info("inserting HTML (read from file)");
                            break;
                        }
                        if (DeepaMehtaUtils.isImage(filename)) {
                            HTMLEditorKit kit = (HTMLEditorKit)((JEditorPane)TextEditorPanel.this.textComponent).getEditorKit();
                            HTMLDocument doc = (HTMLDocument)TextEditorPanel.this.textComponent.getDocument();
                            int pos = TextEditorPanel.this.textComponent.getCaretPosition();
                            String imagefile = file.getPath().replace('\\', '/');
                            String html = "<img src=\"" + imagefile + "\"></img>";
                            kit.insertHTML(doc, pos, html, 0, 0, HTML.Tag.IMG);
                            logger.info("inserting <img> tag \"" + html + "\"");
                        } else {
                            logger.warning("only implemented for HTML files -- import canceled");
                        }
                        ++i;
                    }
                } else {
                    logger.warning("no supported flavor " + c);
                }
                return true;
            }
            catch (UnsupportedFlavorException ufe) {
                logger.warning("while dropping to text panel: " + ufe);
            }
            catch (BadLocationException ble) {
                logger.warning("while dropping to text panel: " + ble);
            }
            catch (IOException ioe) {
                logger.warning("while dropping to text panel: " + ioe);
            }
            return super.importData(c, t);
        }

        public int getSourceActions(JComponent c) {
            return 3;
        }

        protected Transferable createTransferable(JComponent c) {
            if (c != TextEditorPanel.this.textComponent) {
                logger.warning("c=" + c);
            }
            this.source = (JTextComponent)c;
            int start = this.source.getSelectionStart();
            int end = this.source.getSelectionEnd();
            Document doc = this.source.getDocument();
            if (start == end) {
                return null;
            }
            try {
                this.p0 = doc.createPosition(start);
                this.p1 = doc.createPosition(end);
                logger.info("p0=" + this.p0 + ", p1=" + this.p1);
            }
            catch (BadLocationException e) {
                logger.warning("can't create position -- unable to remove text from source");
            }
            this.shouldRemove = true;
            String data = this.source.getSelectedText();
            return new StringSelection(data);
        }

        protected void exportDone(JComponent c, Transferable data, int action) {
            if (c != TextEditorPanel.this.textComponent) {
                logger.warning("c=" + c);
            }
            logger.info("action=" + action + ", MOVE=" + 2 + ", shouldRemove=" + this.shouldRemove);
            if (this.shouldRemove && action == 2 && this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                try {
                    TextEditorPanel.this.textComponent.getDocument().remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                }
                catch (BadLocationException e) {
                    logger.warning("can't remove text from source");
                }
            }
            this.source = null;
        }
    }

    class X28HyperlinkListener
    implements HyperlinkListener {
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            HyperlinkEvent.EventType type = hyperlinkEvent.getEventType();
            URL url = hyperlinkEvent.getURL();
            if (type != HyperlinkEvent.EventType.ENTERED && type == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URI(url.toString()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

