/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.client;

import de.deepamehta.DeepaMehtaConstants;
import de.deepamehta.DeepaMehtaException;
import de.deepamehta.FileServer;
import de.deepamehta.client.GraphEdge;
import de.deepamehta.client.GraphNode;
import de.deepamehta.client.GraphPanel;
import de.deepamehta.client.GraphPanelControler;
import de.deepamehta.client.Selection;
import de.deepamehta.client.TextEditorPanel;
import de.deepamehta.client.X28Edge;
import de.deepamehta.client.X28InitMap;
import de.deepamehta.client.X28Node;
import de.deepamehta.client.X28PasteWindow;
import de.deepamehta.topics.helper.TopicMapExporter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public final class PresentationService
implements DeepaMehtaConstants,
GraphPanelControler,
ActionListener,
Runnable {
    private JButton OK;
    X28InitMap x28InitMap;
    X28PasteWindow x28PasteWindow;
    Hashtable nodes;
    Hashtable edges;
    Hashtable newNodes;
    Hashtable newEdges;
    GraphNode x28Dummy;
    GraphNode x28Topic;
    GraphEdge x28Dummy2;
    GraphEdge x28Assoc;
    String x28InitText;
    private boolean x28SetupDone;
    HyperlinkListener listener;
    TextEditorPanel edi;
    TextEditorPanel labelField;
    public String x28Filename;
    private static Logger logger = Logger.getLogger("de.deepamehta");
    private Vector requestQueue;
    private DefaultBoundedRangeModel progressModel;
    private FileServer fileServer;
    public String hostAddress;
    public String platform;
    Font[][] font;
    private int textsize;
    private String currentPath;
    private boolean firstPaint;
    public JFrame mainWindow;
    public Container cp;
    GraphPanel graphPanel;
    private JPanel cardPanel;
    Selection selection;

    public PresentationService() {
        this.x28Topic = this.x28Dummy = new X28Node(null, null, null, null, null);
        this.x28Assoc = this.x28Dummy2 = new X28Edge(null, null, null, null, null, null);
        this.x28InitText = "<body><font color=\"gray\"><em>Click a node for its details, ALT+drag a node to connect it.<br />&nbsp;<br />For help, right-click the canvas background.</em></font></body>";
        this.x28SetupDone = false;
        this.edi = new TextEditorPanel(2, this.listener, this, true);
        this.labelField = new TextEditorPanel(3, this.listener, this, false);
        this.x28Filename = "";
        this.requestQueue = new Vector();
        this.progressModel = new DefaultBoundedRangeModel();
        this.font = new Font[3][2];
        this.textsize = 1;
        this.firstPaint = true;
        try {
            this.hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.warning("can't get localhost's address (" + e + ")");
        }
        this.platform = System.getProperty("os.name");
        String baseDir = null;
        try {
            baseDir = String.valueOf(System.getProperty("user.home")) + "/" + "Desktop/";
            logger.info("file repository path: " + baseDir);
        }
        catch (Throwable e) {
            logger.warning("can't get user's home directory (" + e + ") -- disable client-side file repository");
        }
        this.fileServer = new FileServer(baseDir, this.progressModel);
        new Thread(this).start();
    }

    public void x28AddToLabel(String textToAdd) {
        if (this.x28Topic == this.x28Dummy) {
            return;
        }
        String oldText = this.labelField.getText();
        String newText = String.valueOf(oldText) + " " + textToAdd;
        this.labelField.setText(newText);
        GraphNode justUpdated = this.x28Topic;
        this.graphSelected();
        this.graphPanel.x28Update(true);
        this.nodeSelected(justUpdated);
        this.graphPanel.x28Update(false);
        this.mainWindow.repaint();
    }

    public void x28Deselect(GraphNode node) {
        if (!node.equals(this.x28Dummy)) {
            String nodeName = node.getName();
            ((X28Node)node).setName(this.labelField.getText());
            ((X28Node)node).setVerbal(this.edi.getText());
            this.edi.setText("");
            this.labelField.setText("");
        }
    }

    public void x28Deselect2(GraphEdge edge) {
        if (!edge.equals(this.x28Dummy2)) {
            String edgeName = edge.getName();
            ((X28Edge)edge).setVerbal(this.edi.getText());
            this.edi.setText("");
            this.labelField.setText("");
        }
    }

    public GraphNode x28CreateNode(Point geometry) {
        if (geometry != null) {
            String newId = this.X28NewKey(this.nodes);
            X28Node topic = new X28Node(newId, "", "", geometry, Color.gray);
            this.nodes.put(newId, topic);
            return topic;
        }
        return null;
    }

    public void x28DeleteEdge(GraphEdge assoc) {
        this.x28DeleteEdge(assoc, false);
    }

    public void x28DeleteEdge(GraphEdge assoc, boolean silent) {
        GraphNode topic1 = assoc.getNode1();
        GraphNode topic2 = assoc.getNode2();
        if (!silent) {
            String topicName1 = topic1.getName();
            String topicName2 = topic2.getName();
            if (topicName1.length() > 30) {
                topicName1 = String.valueOf(topicName1.substring(0, 30)) + "...";
            }
            if (topicName2.length() > 30) {
                topicName2 = String.valueOf(topicName2.substring(0, 30)) + "...";
            }
            JOptionPane question = new JOptionPane();
            int response = JOptionPane.showConfirmDialog(this.OK, "Are you sure you want to delete the association \nfrom \"" + topicName1 + "\" to \"" + topicName2 + "\" ?");
            if (response != 0) {
                return;
            }
        }
        String assocKey = assoc.getID();
        String topicID1 = topic1.getID();
        String topicID2 = topic2.getID();
        this.edges.remove(assocKey);
        topic1.removeEdge(assoc);
        topic2.removeEdge(assoc);
        this.nodes.put(topicID1, topic1);
        this.nodes.put(topicID2, topic2);
    }

    public void x28DeleteNode(GraphNode topic) {
        GraphEdge edge;
        Enumeration e = topic.getEdges();
        Vector<GraphEdge> todoList = new Vector<GraphEdge>();
        int neighborCount = 0;
        while (e.hasMoreElements()) {
            edge = (GraphEdge)e.nextElement();
            todoList.addElement(edge);
            ++neighborCount;
        }
        String topicName = topic.getName();
        if (topicName.length() > 30) {
            topicName = String.valueOf(topicName.substring(0, 30)) + "...";
        }
        JOptionPane question = new JOptionPane();
        int response = JOptionPane.showConfirmDialog(this.OK, "Are you sure you want to delete the topic \n \"" + topicName + "\" with " + neighborCount + " associations ?");
        if (response != 0) {
            return;
        }
        Enumeration e2 = todoList.elements();
        while (e2.hasMoreElements()) {
            edge = (GraphEdge)e2.nextElement();
            this.x28DeleteEdge(edge, true);
        }
        String topicKey = topic.getID();
        this.nodes.remove(topicKey);
    }

    public GraphEdge x28CreateEdge(GraphNode topic1, GraphNode topic2) {
        if (topic1 != null && topic2 != null) {
            String newId = this.X28NewKey(this.edges);
            X28Edge assoc = new X28Edge(newId, "", "", topic1, topic2, Color.gray);
            this.edges.put(newId, assoc);
            topic1.addEdge(assoc);
            String topicID1 = topic1.getID();
            String topicID2 = topic2.getID();
            assoc.setTopicID1(topicID1);
            this.nodes.put(topicID1, topic1);
            topic2.addEdge(assoc);
            assoc.setTopicID2(topicID2);
            this.nodes.put(topicID2, topic2);
            return assoc;
        }
        return null;
    }

    public String X28NewKey(Hashtable table) {
        int max = table.size();
        int i = 1;
        while (i <= max) {
            String idTest = "id" + String.valueOf(100 + i);
            if (!table.containsKey(idTest)) {
                return idTest;
            }
            ++i;
        }
        return "error";
    }

    public void x28StartExport() {
        System.out.println("Save is starting...");
        String fileBasename = this.x28Filename;
        if (this.x28Filename.isEmpty()) {
            fileBasename = "savefile";
        }
        try {
            File exportFile = new TopicMapExporter(this.nodes, this.edges).createTopicmapArchive(fileBasename);
            System.out.println("Save finished. " + fileBasename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initialize() {
        Color newColor;
        String newVerbal;
        boolean pasteFinished = false;
        if (this.x28Filename.isEmpty()) {
            this.x28PasteWindow = new X28PasteWindow();
            while (!pasteFinished) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
                pasteFinished = this.x28PasteWindow.isFinished();
            }
            this.x28Filename = this.x28PasteWindow.getX28Filename();
        }
        Point x28NewOrigin = new Point(10, 10);
        if (this.x28SetupDone) {
            x28NewOrigin = this.graphPanel.x28FindSpace();
        } else {
            this.nodes = new Hashtable();
            this.nodes.clear();
            this.edges = new Hashtable();
            this.edges.clear();
        }
        if (!this.x28Filename.isEmpty()) {
            X28InitMap x28InitMap = new X28InitMap(this);
            this.newNodes = x28InitMap.getX28Nodes();
            this.newEdges = x28InitMap.getX28Edges();
        } else {
            this.newNodes = this.x28PasteWindow.getX28Nodes();
            this.newEdges = this.x28PasteWindow.getX28Edges();
        }
        Hashtable<String, String> x28Concordance = new Hashtable<String, String>();
        Enumeration e = this.newNodes.elements();
        while (e.hasMoreElements()) {
            X28Node node = (X28Node)e.nextElement();
            String newName = node.getName();
            String oldID = node.getID();
            newVerbal = node.getVerbal();
            newColor = node.getColor();
            Point newP = node.getGeometry();
            int x = (int)(newP.getX() + x28NewOrigin.getX());
            int y = (int)(newP.getY() + x28NewOrigin.getY());
            newP.move(x, y);
            GraphNode newNode = this.x28CreateNode(newP);
            ((X28Node)newNode).setName(newName);
            ((X28Node)newNode).setVerbal(newVerbal);
            ((X28Node)newNode).setColor(newColor);
            String newID = newNode.getID();
            x28Concordance.put(oldID, newID);
        }
        Enumeration ee = this.newEdges.elements();
        while (ee.hasMoreElements()) {
            X28Edge edge = (X28Edge)ee.nextElement();
            String newName = edge.getName();
            newVerbal = edge.getVerbal();
            newColor = edge.getColor();
            GraphNode oldNode1 = edge.getNode1();
            GraphNode oldNode2 = edge.getNode2();
            String oldID1 = oldNode1.getID();
            String oldID2 = oldNode2.getID();
            String newID1 = (String)x28Concordance.get(oldID1);
            String newID2 = (String)x28Concordance.get(oldID2);
            GraphNode newNode1 = (GraphNode)this.nodes.get(newID1);
            GraphNode newNode2 = (GraphNode)this.nodes.get(newID2);
            GraphEdge newEdge = this.x28CreateEdge(newNode1, newNode2);
            ((X28Edge)newEdge).setName(newName);
            ((X28Edge)newEdge).setVerbal(newVerbal);
            ((X28Edge)newEdge).setColor(newColor);
        }
        this.edi.setText(this.x28InitText);
        this.edi.getTextComponent().setCaretPosition(0);
        UIDefaults defaults = UIManager.getDefaults();
        String fontname = ((Font)defaults.get("Label.font")).getName();
        int i = 0;
        while (i < 3) {
            this.font[i][0] = new Font(fontname, 0, FONT_SIZES[i]);
            this.font[i][1] = new Font(fontname, 1, FONT_SIZES[i]);
            ++i;
        }
        defaults.put("Label.foreground", new ColorUIResource(COLOR_DARK_SHADOW));
        defaults.put("Panel.background", new ColorUIResource(DEFAULT_BGCOLOR));
        defaults.put("Button.font", new FontUIResource(this.font[this.textsize + 1][0]));
        defaults.put("Button.background", new ColorUIResource(COLOR_PROPERTY_PANEL));
        defaults.put("Button.select", new ColorUIResource(COLOR_SELECTION));
        defaults.put("Button.focus", new ColorUIResource(COLOR_DARK_SHADOW));
        defaults.put("RadioButton.font", new FontUIResource(this.font[this.textsize + 1][0]));
        defaults.put("RadioButton.background", new ColorUIResource(COLOR_PROPERTY_PANEL));
        defaults.put("RadioButton.select", new ColorUIResource(COLOR_SELECTION));
        defaults.put("RadioButton.focus", new ColorUIResource(COLOR_DARK_SHADOW));
        defaults.put("ComboBox.font", new FontUIResource(this.font[this.textsize + 1][1]));
        defaults.put("ComboBox.background", new ColorUIResource(DEFAULT_BGCOLOR));
        defaults.put("ComboBox.selectionBackground", new ColorUIResource(COLOR_SELECTION));
        defaults.put("Menu.font", new FontUIResource(this.font[this.textsize + 1][1]));
        defaults.put("Menu.background", new ColorUIResource(DEFAULT_BGCOLOR));
        defaults.put("Menu.selectionBackground", new ColorUIResource(COLOR_SELECTION));
        defaults.put("MenuItem.font", new FontUIResource(this.font[this.textsize + 1][1]));
        defaults.put("MenuItem.background", new ColorUIResource(DEFAULT_BGCOLOR));
        defaults.put("MenuItem.selectionBackground", new ColorUIResource(COLOR_SELECTION));
        defaults.put("MenuItem.disabledForeground", new ColorUIResource(COLOR_DARK_SHADOW));
        defaults.put("RadioButtonMenuItem.font", new FontUIResource(this.font[this.textsize + 1][1]));
        defaults.put("RadioButtonMenuItem.background", new ColorUIResource(DEFAULT_BGCOLOR));
        defaults.put("RadioButtonMenuItem.selectionBackground", new ColorUIResource(COLOR_SELECTION));
        defaults.put("TextField.font", new FontUIResource(this.font[this.textsize + 1][0]));
        defaults.put("TextField.background", new ColorUIResource(COLOR_VIEW_BGCOLOR));
        defaults.put("TextField.selectionBackground", new ColorUIResource(COLOR_SELECTION));
        defaults.put("TextField.inactiveForeground", new ColorUIResource(COLOR_DARK_SHADOW));
        defaults.put("TextArea.font", new FontUIResource(this.font[this.textsize + 1][0]));
        defaults.put("TextArea.background", new ColorUIResource(COLOR_VIEW_BGCOLOR));
        defaults.put("TextArea.selectionBackground", new ColorUIResource(COLOR_SELECTION));
        defaults.put("TextArea.inactiveForeground", new ColorUIResource(COLOR_DARK_SHADOW));
        defaults.put("TextPane.font", new FontUIResource(this.font[this.textsize + 1][0]));
        defaults.put("TextPane.background", new ColorUIResource(COLOR_VIEW_BGCOLOR));
        defaults.put("TextPane.selectionBackground", new ColorUIResource(COLOR_SELECTION));
        defaults.put("TextPane.inactiveForeground", new ColorUIResource(COLOR_DARK_SHADOW));
        defaults.put("PasswordField.font", new FontUIResource(this.font[this.textsize + 1][0]));
        defaults.put("PasswordField.background", new ColorUIResource(COLOR_VIEW_BGCOLOR));
        defaults.put("PasswordField.selectionBackground", new ColorUIResource(COLOR_SELECTION));
        defaults.put("Separator.foreground", new ColorUIResource(COLOR_DARK_SHADOW));
        defaults.put("TitledBorder.font", new FontUIResource(this.font[this.textsize][0]));
        defaults.put("TitledBorder.titleColor", new ColorUIResource(COLOR_DARK_SHADOW));
    }

    public void createMainWindow(String title) {
        this.mainWindow = new JFrame(title){

            public void paint(Graphics g) {
                try {
                    super.paint(g);
                    if (PresentationService.this.firstPaint) {
                        PresentationService.this.firstPaint = false;
                    }
                }
                catch (Throwable t) {
                    System.out.println("*** mainWindow paint(): " + t);
                }
            }
        };
        this.mainWindow.setSize(300, 105);
        this.mainWindow.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PresentationService.this.close();
            }
        });
        this.cp = this.mainWindow.getContentPane();
    }

    private Font getFont() {
        return this.font[this.textsize + 1][0];
    }

    public void nodeSelected(GraphNode node) {
        this.x28Deselect(this.x28Topic);
        this.x28Deselect2(this.x28Assoc);
        this.x28Assoc = this.x28Dummy2;
        this.x28Topic = node;
        this.edi.setText(((X28Node)this.x28Topic).getVerbal());
        this.edi.getTextComponent().setCaretPosition(0);
        String labelText = ((X28Node)this.x28Topic).getName();
        this.labelField.setText(labelText);
        this.edi.repaint();
    }

    public void edgeSelected(GraphEdge edge) {
        this.x28Deselect2(this.x28Assoc);
        this.x28Deselect(this.x28Topic);
        this.x28Topic = this.x28Dummy;
        this.x28Assoc = edge;
        this.edi.setText(((X28Edge)this.x28Assoc).getVerbal());
        this.edi.getTextComponent().setCaretPosition(0);
        this.edi.getTextComponent().requestFocus();
        this.edi.repaint();
    }

    public void graphSelected() {
        this.x28Deselect(this.x28Topic);
        this.x28Topic = this.x28Dummy;
        this.x28Deselect2(this.x28Assoc);
        this.x28Assoc = this.x28Dummy2;
        this.edi.setText(this.x28InitText);
    }

    public void showNodeMenu(GraphNode node, int x, int y) {
        GraphNode topic = node;
        this.graphPanel.showMenu("node", x, y);
    }

    public void showEdgeMenu(GraphEdge edge, int x, int y) {
        GraphEdge assoc = edge;
        this.graphPanel.showMenu("edge", x, y);
    }

    public void showGraphMenu(int x, int y) {
        String command = "getViewCommands|" + x + "|" + y;
        this.graphPanel.showMenu("view", x, y);
    }

    public void repaint() {
        this.cardPanel.repaint();
    }

    public void beginTranslation() {
        this.setHandCursor();
    }

    public void beginCreatingEdge() {
        this.setCrosshairCursor();
    }

    public void beginLongTask() {
        this.setWaitCursor();
    }

    public void endTask() {
        this.setDefaultCursor();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        throw new DeepaMehtaException("unexpected action command: \"" + command + "\"");
    }

    public void displayHelp() {
        JOptionPane.showMessageDialog(this.mainWindow, "Provisional Help, Release 11\n\nNodes:\n(Left-) Click on a node to view its detail in the right panel;\n(Left-) Drag a node to move it;\nMiddlebutton-Drag a node to connect it with another one;\nRight-Click a node to change its style or delete it;\n\nLines:\n(Left-) Drag a connector-line to move all connected nodes;\nRight-Click a line to change its style or delete it;\nTo create a line, drag a node with the Middle Mouse button or ALT.\n\nBackground:\nRight-Click the canvas background to \n-- create a new node,\n-- save your map to Desktop\\deepamehta-files\\,\n-- or view this help;\n(Left-) Drag the canvas background to move all nodes;\n\nIn the right panel,\n-- click the \"B\"/ \"I\"/ \"U\" for bold/ italic/ underline,\n-- click the \"B+\" Bold Special to add the marked text to\n   the node's label above and on the map\n\nIn the Paste Window at Startup map creation,\n-- Tab-separated text lines are interpreted as label + detail;\n-- short lines are used as labels;\n-- longer lines will be numbered, instead;\n-- if most lines have a comma near the beginning,\n   the text is treated as a reference list.");
    }

    public void x28ToggleHyp() {
        this.edi.x28ToggleHyp();
    }

    public void run() {
        while (true) {
            if (this.requestQueue.size() == 0) {
                this.waitForRequest();
                continue;
            }
            QueuedRequest request = (QueuedRequest)this.requestQueue.firstElement();
            this.performRequest(request);
        }
    }

    void setWaitCursor() {
        this.setMouseCursor(3);
    }

    void setHandCursor() {
        this.setMouseCursor(12);
    }

    void setCrosshairCursor() {
        this.setMouseCursor(1);
    }

    void setDefaultCursor() {
        this.setMouseCursor(0);
    }

    private void setMouseCursor(int cursorType) {
        this.mainWindow.setCursor(new Cursor(cursorType));
    }

    public String chooseFile() {
        String path = "";
        try {
            JFileChooser chooser = new JFileChooser(this.currentPath);
            int returnVal = chooser.showOpenDialog(this.mainWindow);
            if (returnVal == 0) {
                File file = chooser.getSelectedFile();
                path = file.getPath().replace('\\', '/');
                this.currentPath = file.getParent();
            }
        }
        catch (Exception e) {
            this.close();
            System.out.println("*** PresentationService.chooseFile(): " + e + " -- filechooser dialog not displayed");
            JOptionPane.showMessageDialog(this.mainWindow, "Filechooser dialog can't be displayed because of security restrictions >>> Please use the command line.");
        }
        return path;
    }

    private synchronized void waitForRequest() {
        try {
            this.progressModel.setValue(0);
            this.progressModel.setMaximum(0);
            this.wait();
        }
        catch (InterruptedException e) {
            System.out.println("*** PresentationService.waitForRequest(): " + e);
        }
    }

    private void performRequest(QueuedRequest request) {
        request.type;
        System.out.println("*** PresentationService.performRequest(): unexpected request type: " + request.type);
    }

    public JSplitPane createMainGUI() {
        this.selection = new Selection();
        this.graphPanel = new GraphPanel(this);
        this.graphPanel.setModel(this.nodes, this.edges, this.selection, this.getFont());
        JSplitPane splitPane = new JSplitPane(1, true);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(728);
        splitPane.setResizeWeight(0.8);
        splitPane.setDividerSize(8);
        splitPane.setLeftComponent(this.graphPanel);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        JPanel labelBox = new JPanel();
        labelBox.setLayout(new BorderLayout());
        labelBox.add((Component)new JLabel("Label"), "Center");
        labelBox.add((Component)this.labelField, "South");
        Dimension dim = new Dimension(1400, 150);
        labelBox.setMaximumSize(dim);
        rightPanel.add((Component)labelBox, "North");
        JPanel detailBox = new JPanel();
        detailBox.setLayout(new BoxLayout(detailBox, 1));
        detailBox.add(new JLabel("Detail"));
        detailBox.add((Component)this.edi, "South");
        rightPanel.add((Component)detailBox, "South");
        splitPane.setRightComponent(rightPanel);
        this.cp.add(splitPane);
        this.x28SetupDone = true;
        return splitPane;
    }

    void close() {
        JOptionPane closeWarning = new JOptionPane();
        Object[] closeOptions = new Object[]{"Save", "Exit now"};
        int closeResponse = JOptionPane.showOptionDialog(null, "If you have unsaved changes, consider saving the map.\nThe default location for new maps is \"savefile.zip\"\n in your \"Desktop\\deepamehta-files\" folder.\n", "Warning", -1, 2, null, closeOptions, closeOptions[0]);
        if (closeResponse != 1) {
            this.x28StartExport();
        }
        System.out.println("--- presentation service stopped ---");
        System.exit(0);
    }

    public void x28SetFilename(String args) {
        if (this.x28Filename.isEmpty()) {
            this.x28Filename = args;
        }
    }

    private class QueuedRequest {
        private int type;

        private QueuedRequest() {
        }
    }
}

