/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.client;

import de.deepamehta.DeepaMehtaConstants;
import de.deepamehta.DeepaMehtaException;
import de.deepamehta.client.GraphEdge;
import de.deepamehta.client.GraphNode;
import de.deepamehta.client.GraphPanelControler;
import de.deepamehta.client.Selection;
import de.deepamehta.util.DeepaMehtaUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class GraphPanel
extends JDesktopPane
implements ActionListener,
DeepaMehtaConstants {
    MouseEvent x28LastMouseclick;
    boolean x28Updatenode = false;
    String[] onOff = new String[]{"off", "on"};
    int x28Toggle = 1;
    private static final int CLICKED_ON_ICON = 1;
    private static final int CLICKED_ON_NAME = 2;
    private Hashtable nodes;
    private Hashtable edges;
    private Vector allNodeTypesV;
    Hashtable allNodeTypes;
    private Vector allEdgeTypesV;
    Hashtable allEdgeTypes;
    private GraphPanelControler controler;
    private Selection selection;
    private Point translation;
    private Rectangle bounds;
    private Hashtable details;
    private boolean dragInProgress;
    private boolean translateInProgress;
    private boolean moveInProgress;
    private boolean edgeInProgress;
    private boolean clusterInProgress;
    private Hashtable cluster;
    private GraphNode targetNode;
    private int ex;
    private int ey;
    private int mX;
    private int mY;
    private int topicMenuItemCount;
    private boolean creatingEdgesEnabled;
    private Vector currentBunch;
    private int currentBunchIndex;
    private int width;
    private int height;
    private Font font;
    private FontMetrics metrics;
    private Image corporateImage;
    private Image customerImage;
    private Image topImage;
    private Image bottomImage;
    private Image leftImage;
    private Image rightImage;
    JMenuItem delAssoc;
    JMenuItem delTopic;
    JComponent graphPanel;

    GraphPanel(GraphPanelControler controler) {
        this.controler = controler;
        this.setLayout(null);
        this.selection = new Selection();
        this.graphPanel = new JComponent(){
            boolean firstPaint = true;

            public void paint(Graphics g) {
                block4: {
                    if (GraphPanel.this.nodes == null && GraphPanel.this.edges == null) {
                        System.out.println("*** GraphPanel can't be painted (no model set)");
                        return;
                    }
                    try {
                        if (this.firstPaint) {
                            GraphPanel.this.metrics = g.getFontMetrics(GraphPanel.this.font);
                            this.firstPaint = false;
                        }
                    }
                    catch (Throwable e) {
                        if (!this.firstPaint) break block4;
                        System.out.println(">>> Drawing is not antialiased (JDK 1.2 is required): " + e + ", font=" + GraphPanel.this.font);
                        this.firstPaint = false;
                    }
                }
                g.translate(((GraphPanel)GraphPanel.this).translation.x, ((GraphPanel)GraphPanel.this).translation.y);
                this.paintEdges(g);
                this.paintNodes(g);
                this.paintCorporateImages(g);
            }

            private void paintNodes(Graphics g) {
                Enumeration e = GraphPanel.this.nodes.elements();
                GraphNode node = null;
                while (e.hasMoreElements()) {
                    try {
                        node = (GraphNode)e.nextElement();
                        GraphPanel.this.paintNode(node, g);
                    }
                    catch (DeepaMehtaException deepaMehtaException) {
                        // empty catch block
                    }
                }
            }

            private void paintEdges(Graphics g) {
                Enumeration e = GraphPanel.this.edges.elements();
                while (e.hasMoreElements()) {
                    GraphEdge edge = (GraphEdge)e.nextElement();
                    GraphPanel.this.paintEdge(edge, g);
                }
                if (GraphPanel.this.edgeInProgress) {
                    Point p = ((GraphPanel)GraphPanel.this).selection.topic.getGeometry();
                    g.setColor(EDGE_COLOR.darker());
                    DeepaMehtaUtils.paintLine(g, p.x, p.y, GraphPanel.this.ex - ((GraphPanel)GraphPanel.this).translation.x, GraphPanel.this.ey - ((GraphPanel)GraphPanel.this).translation.y, true);
                }
            }

            private void paintBorderImages(Graphics g) {
                if (GraphPanel.this.showTopImage()) {
                    g.drawImage(GraphPanel.this.topImage, (GraphPanel.this.width - 84) / 2, 0, this);
                }
                if (GraphPanel.this.showBottomImage()) {
                    g.drawImage(GraphPanel.this.bottomImage, (GraphPanel.this.width - 84) / 2, GraphPanel.this.height - 12, this);
                }
                if (GraphPanel.this.showLeftImage()) {
                    g.drawImage(GraphPanel.this.leftImage, 0, (GraphPanel.this.height - 84) / 2, this);
                }
                if (GraphPanel.this.showRightImage()) {
                    g.drawImage(GraphPanel.this.rightImage, GraphPanel.this.width - 12, (GraphPanel.this.height - 84) / 2, this);
                }
            }

            private void paintCorporateImages(Graphics g) {
                g.drawImage(GraphPanel.this.corporateImage, GraphPanel.this.width - 104 - ((GraphPanel)GraphPanel.this).translation.x, GraphPanel.this.height - 50 - ((GraphPanel)GraphPanel.this).translation.y, this);
            }
        };
        this.setLayer(this.graphPanel, DEFAULT_LAYER);
        this.setToolTipText("");
        this.add(this.graphPanel);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                GraphPanel.this.thisPanelPressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                GraphPanel.this.thisPanelReleased(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                GraphPanel.this.thisPanelDragged(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Dimension s = GraphPanel.this.getSize();
                GraphPanel.this.graphPanel.setSize(s);
                GraphPanel.this.width = s.width;
                GraphPanel.this.height = s.height;
                GraphPanel.this.repaint();
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        JMenuItem item = (JMenuItem)e.getSource();
        JPopupMenu menu = (JPopupMenu)item.getParent();
        String menuID = menu.getLabel();
        if (menuID.equals("node")) {
            GraphNode node = this.selection.topic;
            Color changedColor = node.getColor();
            if (command == "purple") {
                changedColor = Color.magenta.darker();
            }
            if (command == "blue") {
                changedColor = Color.blue;
            }
            if (command == "green") {
                changedColor = Color.green;
            }
            if (command == "yellow") {
                changedColor = Color.yellow;
            }
            if (command == "orange") {
                changedColor = new Color(255, 170, 0);
            }
            if (command == "red") {
                changedColor = Color.red;
            }
            if (command == "lightGray") {
                changedColor = Color.lightGray;
            }
            node.setColor(changedColor);
            if (command == "delTopic") {
                this.controler.x28DeleteNode(node);
                this.selection.mode = 1;
                this.selection.topic = null;
                this.graphSelected();
            }
            this.repaint();
        } else if (menuID.equals("edge")) {
            GraphEdge edge = this.selection.assoc;
            Color changedColor = edge.getColor();
            if (command == "purple") {
                changedColor = Color.magenta.darker();
            }
            if (command == "blue") {
                changedColor = Color.blue;
            }
            if (command == "green") {
                changedColor = Color.green;
            }
            if (command == "yellow") {
                changedColor = Color.yellow;
            }
            if (command == "orange") {
                changedColor = new Color(255, 170, 0);
            }
            if (command == "red") {
                changedColor = Color.red;
            }
            if (command == "lightGray") {
                changedColor = new Color(216, 216, 216);
            }
            edge.setColor(changedColor);
            if (command == "delAssoc") {
                this.controler.x28DeleteEdge(edge);
                this.selection.mode = 1;
                this.selection.assoc = null;
                this.graphSelected();
            }
            this.repaint();
        } else if (menuID.equals("view")) {
            if (command == "export") {
                this.controler.x28StartExport();
            } else if (command == "NewNode") {
                this.mX -= this.translation.x;
                this.mY -= this.translation.y;
                Point p = new Point(this.mX, this.mY);
                GraphNode node = this.controler.x28CreateNode(p);
                this.nodeSelected(node);
            } else if (command == "ToggleHyp") {
                this.controler.x28ToggleHyp();
                this.x28Toggle = 1 - this.x28Toggle;
            } else if (command == "?") {
                this.controler.displayHelp();
            } else {
                System.out.println(String.valueOf(command) + " not yet supported");
            }
        }
        this.controler.endTask();
    }

    void x28Update(boolean onOff) {
        this.x28Updatenode = onOff;
    }

    public String getToolTipText(MouseEvent evt) {
        int y;
        int x = evt.getX();
        Vector foundNodes = this.findAllNodes(x, y = evt.getY());
        int count = foundNodes.size();
        if (count == 0) {
            return null;
        }
        boolean showTip = false;
        StringBuffer tipText = new StringBuffer("<html>");
        Enumeration e = foundNodes.elements();
        while (e.hasMoreElements()) {
            GraphNode node = ((FoundNode)e.nextElement()).node;
            if (count != 1 && count <= 1) continue;
            tipText.append(String.valueOf(showTip ? "<br>" : "") + (count > 1 ? "- " : "") + node.getName());
            showTip = true;
        }
        return showTip ? tipText.toString() : null;
    }

    void setTypes(Vector nodeTypesV, Hashtable nodeTypes, Vector edgeTypesV, Hashtable edgeTypes) {
        this.allNodeTypes = nodeTypes;
        this.allNodeTypesV = nodeTypesV;
        this.allEdgeTypes = edgeTypes;
        this.allEdgeTypesV = edgeTypesV;
    }

    void setImages(Image corpImg, Image custImg, Image topImg, Image leftImg, Image buttomImg, Image rightImg) {
        this.corporateImage = corpImg;
        this.customerImage = custImg;
        this.topImage = topImg;
        this.leftImage = leftImg;
        this.bottomImage = buttomImg;
        this.rightImage = rightImg;
    }

    void setModel(Hashtable nodes, Hashtable edges, Selection selection, Font font) {
        this.nodes = nodes;
        this.edges = edges;
        this.translation = new Point(0, 0);
        this.selection = selection;
        this.bounds = this.bounds;
        this.creatingEdgesEnabled = this.creatingEdgesEnabled;
        this.font = font;
        this.setBackgroundColor(Color.white);
    }

    int getSelected() {
        return this.selection.mode;
    }

    Point getTranslation() {
        return this.translation;
    }

    void setBackgroundColor(Color color) {
        this.setBackground(color);
    }

    void showMenu(String menuID, int x, int y) {
        JPopupMenu menu = new JPopupMenu(menuID);
        if (menuID.equals("view")) {
            JMenuItem item = new JMenuItem();
            item.addActionListener(this);
            item.setActionCommand("export");
            item.setText("Save map...");
            menu.add(item);
            JMenuItem item2 = new JMenuItem();
            item2.addActionListener(this);
            item2.setActionCommand("NewNode");
            item2.setText("New node");
            menu.add(item2);
            JMenuItem item4 = new JMenuItem();
            item4.addActionListener(this);
            item4.setActionCommand("ToggleHyp");
            item4.setText("Toggle hyperlinks " + this.onOff[this.x28Toggle]);
            menu.add(item4);
            JMenuItem item3 = new JMenuItem();
            item3.addActionListener(this);
            item3.setActionCommand("?");
            item3.setText("Help");
            menu.add(item3);
        } else if (menuID.equals("node")) {
            JMenuItem delTopic = new JMenuItem();
            delTopic.addActionListener(this);
            delTopic.setActionCommand("delTopic");
            delTopic.setText("Delete");
            menu.add(this.x28StyleSwitcher(1, "purple", Color.magenta.darker(), true));
            menu.add(this.x28StyleSwitcher(2, "blue", Color.blue, true));
            menu.add(this.x28StyleSwitcher(3, "green", Color.green, false));
            menu.add(this.x28StyleSwitcher(4, "yellow", Color.yellow, false));
            menu.add(this.x28StyleSwitcher(5, "orange", Color.orange, false));
            menu.add(this.x28StyleSwitcher(6, "red", Color.red, true));
            menu.add(this.x28StyleSwitcher(7, "lightGray", Color.lightGray, false));
            menu.addSeparator();
            menu.add(delTopic);
        } else if (menuID.equals("edge")) {
            JMenuItem delAssoc = new JMenuItem();
            delAssoc.addActionListener(this);
            delAssoc.setActionCommand("delAssoc");
            delAssoc.setText("Delete");
            menu.add(this.x28StyleSwitcher(1, "purple", Color.magenta.darker(), true));
            menu.add(this.x28StyleSwitcher(2, "blue", Color.blue, true));
            menu.add(this.x28StyleSwitcher(3, "green", Color.green, false));
            menu.add(this.x28StyleSwitcher(4, "yellow", Color.yellow, false));
            menu.add(this.x28StyleSwitcher(5, "orange", Color.orange, false));
            menu.add(this.x28StyleSwitcher(6, "red", Color.red, true));
            menu.add(this.x28StyleSwitcher(7, "lightGray", Color.lightGray, false));
            menu.addSeparator();
            menu.add(delAssoc);
        }
        menu.show(this, x, y);
    }

    JMenuItem x28StyleSwitcher(int styleNumber, String styleName, Color color, boolean reverse) {
        JMenuItem styleItem = new JMenuItem();
        styleItem.addActionListener(this);
        styleItem.setActionCommand(styleName);
        styleItem.setBackground(color);
        if (reverse) {
            styleItem.setForeground(Color.white);
        }
        styleItem.setText("Change color");
        if (styleNumber == 7) {
            styleItem.setText("Pale");
        }
        return styleItem;
    }

    void addDetailWindow(JInternalFrame detailWindow) {
        this.setLayer(detailWindow, JLayeredPane.PALETTE_LAYER);
        this.add(detailWindow);
    }

    private void paintNode(GraphNode node, Graphics g) throws DeepaMehtaException {
        Point p = node.getGeometry();
        if (p == null) {
            throw new DeepaMehtaException("topic has no geometry");
        }
        int iconWidth = 18;
        int iconHeight = 18;
        int iw2 = iconWidth / 2;
        int ih2 = iconHeight / 2;
        Color color = node.getColor();
        g.setColor(color);
        g.fillOval(p.x - iw2, p.y - ih2, 18, 18);
        if (node == this.selection.topic && this.getSelected() == 2) {
            g.setColor(Color.red);
            g.drawRect(p.x - iw2 - 2, p.y - ih2 - 2, iconWidth + 3, iconHeight + 3);
            g.drawRect(p.x - iw2 - 3, p.y - ih2 - 3, iconWidth + 5, iconHeight + 5);
        }
        g.setFont(this.font);
        g.setColor(TEXT_COLOR);
        g.drawString(node.getName(), p.x - iw2, p.y - ih2 + iconHeight + this.font.getSize() + 2);
        if (node.getLabel() != null) {
            g.drawString(node.getLabel(), p.x - iw2, p.y - ih2 - 4);
        }
    }

    private void paintEdge(GraphEdge edge, Graphics g) {
        GraphNode node1 = edge.getNode1();
        GraphNode node2 = edge.getNode2();
        if (node1 == null) {
            System.out.println("*** GraphPanel.paintEdge(): " + edge.getName() + ": node 1 not set -- edge not painted");
            return;
        }
        if (node2 == null) {
            System.out.println("*** GraphPanel.paintEdge(): " + edge + ": node 2 not set -- edge not painted");
            return;
        }
        Point p1 = node1.getGeometry();
        Point p2 = node2.getGeometry();
        if (p1 == null) {
            System.out.println("*** GraphPanel.paintEdge(): " + node1 + " has no gemoetry -- edge not painted");
            return;
        }
        if (p2 == null) {
            System.out.println("*** GraphPanel.paintEdge(): " + node2 + " has no gemoetry -- edge not painted");
            return;
        }
        if (edge == this.selection.assoc && this.getSelected() == 3) {
            g.setColor(Color.red);
            g.drawLine(p1.x - 2, p1.y - 2, p2.x - 2, p2.y - 2);
            g.drawLine(p1.x + 3, p1.y - 2, p2.x + 3, p2.y - 2);
            g.drawLine(p1.x - 2, p1.y + 3, p2.x - 2, p2.y + 3);
            g.drawLine(p1.x + 2, p1.y + 3, p2.x + 2, p2.y + 3);
        }
        Color color = edge.getColor();
        boolean directed = true;
        g.setColor(color);
        DeepaMehtaUtils.paintLine(g, p1.x, p1.y, p2.x, p2.y, directed);
        g.setFont(this.font);
        g.setColor(TEXT_COLOR);
    }

    private void thisPanelPressed(MouseEvent e) {
        GraphEdge edge;
        this.x28LastMouseclick = e;
        int x = e.getX();
        int y = e.getY();
        this.mX = x;
        this.mY = y;
        FoundNode foundNode = this.findNode(x, y, !this.isSpecial(e));
        GraphNode node = foundNode != null ? foundNode.node : null;
        GraphEdge graphEdge = edge = foundNode == null || foundNode.clickedMode == 2 ? this.findEdge(x, y) : null;
        if (node != null && edge != null) {
            this.edgeClicked(edge, e);
        } else if (node != null) {
            this.nodeClicked(node, e);
        } else if (edge != null) {
            this.edgeClicked(edge, e);
        } else {
            this.graphClicked(e);
        }
    }

    private void thisPanelDragged(MouseEvent e) {
        if (this.moveInProgress || this.clusterInProgress || this.translateInProgress) {
            if (!this.dragInProgress) {
                this.controler.beginTranslation();
                this.dragInProgress = true;
            }
            int x = e.getX();
            int y = e.getY();
            int dx = x - this.mX;
            int dy = y - this.mY;
            this.mX = x;
            this.mY = y;
            if (this.moveInProgress) {
                this.translateNode(this.selection.topic, dx, dy);
            } else if (this.clusterInProgress) {
                this.translateCluster(dx, dy);
            } else {
                this.translateGraph(dx, dy);
            }
            this.repaint();
        } else if (this.edgeInProgress) {
            if (!this.dragInProgress) {
                this.controler.beginCreatingEdge();
                this.dragInProgress = true;
            }
            this.ex = e.getX();
            this.ey = e.getY();
            FoundNode foundNode = this.findNode(this.ex, this.ey, false);
            GraphNode graphNode = this.targetNode = foundNode != null ? foundNode.node : null;
            if (this.targetNode != null) {
                Point p = this.targetNode.getGeometry();
                this.ex = p.x + this.translation.x;
                this.ey = p.y + this.translation.y;
            }
            this.repaint();
        }
    }

    private void thisPanelReleased(MouseEvent e) {
        if (this.moveInProgress) {
            this.moveInProgress = false;
            if (this.dragInProgress) {
                this.controler.endTask();
                this.dragInProgress = false;
            }
        } else if (this.clusterInProgress) {
            this.clusterInProgress = false;
            if (this.dragInProgress) {
                this.controler.endTask();
                this.dragInProgress = false;
            }
        } else if (this.translateInProgress) {
            this.translateInProgress = false;
            if (this.dragInProgress) {
                this.controler.endTask();
                this.dragInProgress = false;
            }
        } else if (this.edgeInProgress) {
            this.edgeInProgress = false;
            this.controler.endTask();
            this.dragInProgress = false;
            if (this.targetNode != null && this.targetNode != this.selection.topic) {
                GraphNode node1 = this.selection.topic;
                GraphNode node2 = this.targetNode;
                GraphEdge graphEdge = this.controler.x28CreateEdge(node1, node2);
            } else {
                this.repaint();
            }
        }
    }

    private void nodeClicked(GraphNode node, MouseEvent e) {
        this.nodeSelected(node);
        int x = e.getX();
        int y = e.getY();
        if (e.getClickCount() != 2) {
            if (e.isAltDown()) {
                this.edgeInProgress = true;
                this.targetNode = null;
                this.ex = x;
                this.ey = y;
            } else if (this.isPopupTrigger(e)) {
                this.controler.showNodeMenu(node, x, y);
            } else {
                this.moveInProgress = true;
            }
        }
    }

    private void edgeClicked(GraphEdge edge, MouseEvent e) {
        this.edgeSelected(edge);
        if (this.isPopupTrigger(e)) {
            this.controler.showEdgeMenu(edge, e.getX(), e.getY());
        }
        this.cluster = this.createNodeCluster(edge.getNode1());
        this.clusterInProgress = true;
    }

    private void graphClicked(MouseEvent e) {
        this.graphSelected();
        if (this.isPopupTrigger(e)) {
            this.controler.showGraphMenu(e.getX(), e.getY());
            this.controler.endTask();
        } else {
            this.translateInProgress = true;
        }
    }

    private void nodeSelected(GraphNode node) {
        if (node != this.selection.topic && !this.x28Updatenode) {
            this.controler.nodeSelected(node);
            this.repaint();
            this.selection.mode = 2;
            this.selection.topic = node;
            this.selection.assoc = null;
        }
    }

    private void edgeSelected(GraphEdge edge) {
        if (edge != this.selection.assoc) {
            this.controler.edgeSelected(edge);
            this.repaint();
            this.selection.mode = 3;
            this.selection.assoc = edge;
            this.selection.topic = null;
        }
    }

    private void graphSelected() {
        if (this.selection.mode != 4) {
            this.repaint();
            this.selection.mode = 4;
            this.selection.topic = null;
            this.selection.assoc = null;
            this.controler.graphSelected();
        }
    }

    private boolean isSpecial(MouseEvent e) {
        return e.getClickCount() == 2 || e.isAltDown() || this.isPopupTrigger(e);
    }

    private boolean isPopupTrigger(MouseEvent e) {
        if (e.isPopupTrigger()) {
            return true;
        }
        return (e.getModifiers() & 4) != 0;
    }

    private Hashtable createNodeCluster(GraphNode node) {
        Hashtable cluster = new Hashtable();
        if (node == null) {
            return cluster;
        }
        this.nodeCluster(node, cluster);
        return cluster;
    }

    private void nodeCluster(GraphNode node, Hashtable cluster) {
        if (node == null) {
            return;
        }
        String id = node.getID();
        if (cluster.get(id) == null) {
            cluster.put(id, node);
            Enumeration e = node.getEdges();
            while (e.hasMoreElements()) {
                GraphEdge edge = (GraphEdge)e.nextElement();
                this.nodeCluster(node.relatedNode(edge), cluster);
            }
        }
    }

    private void translateGraph(int x, int y) {
        this.translation.x += x;
        this.translation.y += y;
    }

    private void translateCluster(int x, int y) {
        Enumeration e = this.cluster.elements();
        while (e.hasMoreElements()) {
            GraphNode node = (GraphNode)e.nextElement();
            this.translateNode(node, x, y);
        }
    }

    private void translateNode(GraphNode node, int x, int y) {
        node.getGeometry().translate(x, y);
    }

    private FoundNode findNode(int x, int y, boolean selectNextInBunch) {
        Vector bunch = this.findAllNodes(x, y);
        if (bunch.equals(this.currentBunch)) {
            if (selectNextInBunch && this.currentBunch.size() > 0) {
                this.currentBunchIndex = (this.currentBunchIndex + 1) % this.currentBunch.size();
            }
        } else {
            this.currentBunch = bunch;
            this.currentBunchIndex = 0;
        }
        return this.currentBunch.size() > 0 ? (FoundNode)this.currentBunch.elementAt(this.currentBunchIndex) : null;
    }

    private Vector findAllNodes(int x, int y) {
        x -= this.translation.x;
        y -= this.translation.y;
        Vector<FoundNode> foundNodes = new Vector<FoundNode>();
        Enumeration e = this.nodes.elements();
        while (e.hasMoreElements()) {
            GraphNode node = (GraphNode)e.nextElement();
            Point p = node.getGeometry();
            Image icon = this.getIcon(node);
            int iconWidth = 18;
            int iconHeight = 18;
            int iw2 = iconWidth / 2;
            int ih2 = iconHeight / 2;
            iw2 = 18;
            ih2 = 18;
            if (Math.abs(x - p.x) <= iw2 && Math.abs(y - p.y) <= ih2) {
                foundNodes.addElement(new FoundNode(node, 1));
            }
            if (x < p.x - iw2 || x > p.x - iw2 + this.metrics.stringWidth(node.getName()) || y < p.y - ih2 + iconHeight + 2 || y > p.y - ih2 + iconHeight + this.font.getSize() + 2) continue;
            foundNodes.addElement(new FoundNode(node, 2));
        }
        return foundNodes;
    }

    private GraphEdge findEdge(int x, int y) {
        Point p2;
        Point p1;
        x -= this.translation.x;
        y -= this.translation.y;
        Enumeration<Object> e = this.edges.elements();
        GraphEdge edge = null;
        Vector<GraphEdge> candidates = new Vector<GraphEdge>();
        while (e.hasMoreElements()) {
            edge = (GraphEdge)e.nextElement();
            GraphNode node1 = edge.getNode1();
            GraphNode node2 = edge.getNode2();
            if (node1 == null || node2 == null || !this.edgeHit(p1 = node1.getGeometry(), p2 = node2.getGeometry(), new Point(x, y))) continue;
            candidates.addElement(edge);
        }
        int candCount = candidates.size();
        if (candCount == 0) {
            return null;
        }
        if (candCount == 1) {
            return (GraphEdge)candidates.firstElement();
        }
        e = candidates.elements();
        float minDist = 100.0f;
        GraphEdge nearestEdge = null;
        while (e.hasMoreElements()) {
            edge = (GraphEdge)e.nextElement();
            p1 = edge.getNode1().getGeometry();
            p2 = edge.getNode2().getGeometry();
            float dist = Math.abs(Math.abs((float)(x - p1.x) / (float)(y - p1.y) / ((float)(p2.x - p1.x) / (float)(p2.y - p1.y))) - 1.0f);
            if (!(dist < minDist)) continue;
            minDist = dist;
            nearestEdge = edge;
        }
        return (double)minDist < 0.3 ? nearestEdge : null;
    }

    private boolean edgeHit(Point p1, Point p2, Point hit) {
        Point a = new Point(hit.x - p1.x, hit.y - p1.y);
        Point b = new Point(p2.x - p1.x, p2.y - p1.y);
        float ab_scalarproduct = (float)a.x * (float)b.x + (float)(a.y * b.y);
        float b_length_square = (float)b.x * (float)b.x + (float)(b.y * b.y);
        if (b_length_square == 0.0f) {
            return false;
        }
        float x = ab_scalarproduct / b_length_square;
        Point c = new Point((int)(x * (float)b.x) - a.x, (int)(x * (float)b.y) - a.y);
        int c_length_square = c.x * c.x + c.y * c.y;
        return 0.0f < x && x < 1.0f && c_length_square <= 25;
    }

    private boolean showTopImage() {
        return !this.isEmpty() && this.bounds.y + this.translation.y < 0;
    }

    private boolean showBottomImage() {
        return !this.isEmpty() && this.bounds.y + this.bounds.height + this.translation.y > this.height;
    }

    private boolean showLeftImage() {
        return !this.isEmpty() && this.bounds.x + this.translation.x < 0;
    }

    private boolean showRightImage() {
        return !this.isEmpty() && this.bounds.x + this.bounds.width + this.translation.x > this.width;
    }

    private Image getIcon(GraphNode node) {
        Image icon = null;
        return icon;
    }

    private GraphNode getNode(String nodeID) {
        return (GraphNode)this.nodes.get(nodeID);
    }

    private GraphEdge getEdge(String edgeID) {
        return (GraphEdge)this.edges.get(edgeID);
    }

    private boolean isEmpty() {
        return this.nodes.size() == 0;
    }

    public Point x28FindSpace() {
        int maxx = 0;
        int maxy = 0;
        int minx = 9999;
        int miny = 9999;
        Enumeration n = this.nodes.elements();
        while (n.hasMoreElements()) {
            int curry;
            GraphNode node = (GraphNode)n.nextElement();
            Point curr = node.getGeometry();
            int currx = (int)curr.getX();
            if (currx > maxx) {
                maxx = currx;
            }
            if (currx < minx) {
                minx = currx;
            }
            if ((curry = (int)curr.getY()) > maxy) {
                maxy = curry;
            }
            if (curry >= miny) continue;
            miny = curry;
        }
        Point pmin = new Point(minx, miny);
        GraphNode node = this.controler.x28CreateNode(pmin);
        this.nodeSelected(node);
        Point pmax = new Point(maxx, maxy);
        node = this.controler.x28CreateNode(pmax);
        this.nodeSelected(node);
        Point pcurr = new Point(this.translation.x, this.translation.y);
        node = this.controler.x28CreateNode(pcurr);
        this.nodeSelected(node);
        System.out.println(String.valueOf(minx) + " < x < " + maxx + "; " + miny + " < y < " + maxy);
        Point x28NewOrigin = new Point(this.translation.x, maxy);
        this.translation.x = minx;
        this.translation.y = maxy - 300;
        return x28NewOrigin;
    }

    private class FoundNode {
        GraphNode node;
        int clickedMode;

        FoundNode(GraphNode node, int clickedMode) {
            this.node = node;
            this.clickedMode = clickedMode;
        }

        public boolean equals(Object o) {
            FoundNode fn = (FoundNode)o;
            return this.node == fn.node && this.clickedMode == fn.clickedMode;
        }
    }
}

