/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta;

import de.deepamehta.DeepaMehtaConstants;
import de.deepamehta.DeepaMehtaException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.BoundedRangeModel;

public class FileServer
implements DeepaMehtaConstants {
    private static String baseDir;
    BoundedRangeModel model;

    public FileServer() {
    }

    public FileServer(String baseDir, BoundedRangeModel model) {
        FileServer.baseDir = baseDir;
        this.model = model;
    }

    public void readFile(File dstFile, DataInputStream in) throws IOException {
        long size = in.readLong();
        System.out.println(">>> Fileserver.readFile(): \"" + dstFile + "\" (" + size + " bytes)");
        FileServer.createDirectory(dstFile);
        BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(dstFile), 32768);
        byte[] buffer = new byte[32768];
        long totalBytes = 0L;
        while (totalBytes < size) {
            long remainingBytes = size - totalBytes;
            int readBytes = remainingBytes >= 32768L ? 32768 : (int)remainingBytes;
            readBytes = in.read(buffer, 0, readBytes);
            ((OutputStream)fileOut).write(buffer, 0, readBytes);
            totalBytes += (long)readBytes;
            if (this.model == null) continue;
            this.model.setValue(this.model.getValue() + 1);
        }
        ((OutputStream)fileOut).close();
        if (totalBytes != size) {
            System.out.println("*** FileServer.readFile(): " + totalBytes + " bytes received (corrupt)");
            throw new IOException("uploaded file \"" + dstFile + "\" is incomplete");
        }
        System.out.println(">>> " + totalBytes + " bytes received");
    }

    public void writeFile(File file, DataOutputStream out) throws IOException {
        int readBytes;
        long size = file.length();
        System.out.println(">>> Fileserver.writeFile(): \"" + file + "\" (" + size + " bytes)");
        BufferedInputStream fileIn = new BufferedInputStream(new FileInputStream(file), 32768);
        byte[] buffer = new byte[32768];
        long totalBytes = 0L;
        out.writeLong(size);
        while ((readBytes = ((InputStream)fileIn).read(buffer)) != -1) {
            out.write(buffer, 0, readBytes);
            totalBytes += (long)readBytes;
            if (this.model == null) continue;
            this.model.setValue(this.model.getValue() + 1);
        }
        if (totalBytes != size) {
            System.out.println("*** FileServer.writeFile(): " + totalBytes + " bytes transmitted (corrupt)");
            throw new IOException("file \"" + file + "\" has been transmitted incompletely");
        }
        System.out.println(">>> " + totalBytes + " bytes transmitted");
    }

    public void copyFile(File srcFile, int filetype) throws IOException {
        int readBytes;
        File dstFile = new File(String.valueOf(FileServer.repositoryPath(filetype)) + srcFile.getName());
        long size = srcFile.length();
        System.out.println(">>> FileServer.copyFile():\n    src=\"" + srcFile + "\" (" + size + " bytes)\n    dst=\"" + dstFile + "\"");
        FileServer.createDirectory(dstFile);
        if (srcFile.equals(dstFile.getAbsoluteFile())) {
            System.out.println(">>> FileServer.copyFile(): " + dstFile + " is already in local " + "repository (type " + filetype + ") -- no copying required");
            return;
        }
        BufferedInputStream fileIn = new BufferedInputStream(new FileInputStream(srcFile), 32768);
        BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(dstFile), 32768);
        byte[] buffer = new byte[32768];
        long totalBytes = 0L;
        while ((readBytes = ((InputStream)fileIn).read(buffer)) != -1) {
            ((OutputStream)fileOut).write(buffer, 0, readBytes);
            totalBytes += (long)readBytes;
            if (this.model == null) continue;
            this.model.setValue(this.model.getValue() + 1);
        }
        ((InputStream)fileIn).close();
        ((OutputStream)fileOut).close();
        if (size != totalBytes) {
            System.out.println("*** FileServer.copyFile(): " + totalBytes + " bytes " + "copied (corrupt)");
            throw new IOException("copy of \"" + srcFile + "\" is corrupt");
        }
        System.out.println(">>> " + totalBytes + " bytes copied");
    }

    public static String repositoryPath(int filetype) {
        String bd = baseDir != null ? baseDir : "";
        switch (filetype) {
            case 1: {
                return String.valueOf(bd) + "deepamehta-files/";
            }
            case 2: {
                return String.valueOf(bd) + "icons/";
            }
            case 3: {
                return String.valueOf(bd) + "images/";
            }
            case 4: {
                return String.valueOf(bd) + "backgrounds/";
            }
        }
        throw new DeepaMehtaException("unexpected filetype: " + filetype);
    }

    public static int getFiletype(String filename) {
        System.out.println(filename);
        if (filename.startsWith("deepamehta-files/".substring(0, "deepamehta-files/".length() - 1))) {
            return 1;
        }
        if (filename.startsWith("icons/".substring(0, "icons/".length() - 1))) {
            return 2;
        }
        if (filename.startsWith("images/".substring(0, "images/".length() - 1))) {
            return 3;
        }
        if (filename.startsWith("backgrounds/".substring(0, "backgrounds/".length() - 1))) {
            return 4;
        }
        throw new DeepaMehtaException("unexpected path: " + filename);
    }

    public static void createDirectory(File file) {
        File dstDir = file.getParentFile();
        if (dstDir.mkdirs()) {
            System.out.println(">>> document repository has been created: " + dstDir);
        }
    }
}

